/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.data;

import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.bindings.TypeConverter;

/**
 * {@link ConstraintValidator} which needs {@link TypeConverter} to implement
 * the validation.
 */
public interface TypeConverterDrivenConstraintValidator extends ConstraintValidator {

    /**
     * Validates the constraint imposed by this validator.
     *
     * @param dataValue data value to validate; must not be {@code null}
     * @param converter type converter to be used in the validation process;
     *        must not be {@code null}
     * @throws ConstraintValidationException if the constraint is not satisfied
     */
    void validate(DataValue dataValue, TypeConverter converter);
}
