/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.diagnostics;

/**
 * @author VMware Inc.
 *
 */
public class DiagnosticsKey {
    private final String componentId;
    private String[] counters = null;
    private String diagnosticsKey;

    public DiagnosticsKey(String componentId) {
        this(componentId, new String[0]);
    }

    public DiagnosticsKey(String componentId,
                          String[] counters) {
        this.componentId = componentId;
        this.counters = counters;
        initializeKey();
    }

    private void initializeKey() {
        diagnosticsKey = componentId;

        for (String componentCategory : counters) {
            diagnosticsKey =
                    diagnosticsKey + ":" + componentCategory;
        }
    }

    public String[] getComponentCounters() {
        return counters;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof DiagnosticsKey)) {
            return false;
        }

        return diagnosticsKey
                .equals(((DiagnosticsKey) obj).diagnosticsKey);
    }

    @Override
    public int hashCode() {
        return diagnosticsKey.hashCode();
    }

    /**
     * Returns the component instance ID.
     *
     * @return The component instance ID, or null if this is a singleton
     *         component.
     */
    public String getComponentId() {
        return componentId;
    }

    @Override
    public String toString() {
        return diagnosticsKey;
    }
}

