/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.dsig.json;

import java.util.Map;

import com.vmware.vapi.dsig.json.SignatureException;

/**
 * Implementations of this interface should be able to verify signatures over a
 * payload
 */
public interface Verifier {

    long DEFAULT_CLOCK_TOLERANCE_SEC = 10 * 60; // 10 minutes

    /**
     * Verifies that the payload is signed with the provided signature.
     *
     * @param payload the signed data. must not be null.
     * @param signature the signature data (includes at least signing algorithm,
     *                  SAML token, signature value etc.). must not be null.
     * @param clockToleranceSec the allowed time discrepancy between the client
     *                          and the server. must not be negative.
     * @return true if the signature is valid, false otherwise
     * @throws SignatureException
     */
    boolean verifySignature(String payload,
                            Map<String, Object> signature,
                            long clockToleranceSec) throws SignatureException;
}
