/* **********************************************************
 * Copyright (c) 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import javax.servlet.http.HttpServletResponse;

import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;

/**
 *
 */
public abstract class BaseResponseParser implements ResponseParser {

    @Override
    public MethodResult parse(String serviceId,
                              String operationId,
                              HttpResponse response) {
        if (isSuccessful(response)) {
            // TODO: rest native: do I still need serviceId/operationId in runtime
            //       module usages?
            return new MethodResult(parseBody(serviceId, operationId, response),
                                    null);
        } else {
            return new MethodResult(null,
                                    parseError(response));
        }
    }

    /**
     * Check if given {@link HttpResponse} represent operation success or is an
     * operation error.
     *
     * <p>This implementation treats responses with HTTP status code in the
     * [200, 300) range as successful ones.
     *
     * @return true if the response is successful
     */
    protected boolean isSuccessful(HttpResponse response) {
        int statusCode = response.getStatusCode();
        return (statusCode >= HttpServletResponse.SC_OK)
                && (statusCode < HttpServletResponse.SC_MULTIPLE_CHOICES);
    }

    protected abstract DataValue parseBody(String serviceId,
                                           String operationId,
                                           HttpResponse response);

    protected abstract ErrorValue parseError(HttpResponse response);
}
