/* **********************************************************
 * Copyright (c) 2016, 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.util.Validate;

/**
 * {@code ResponseParser} implementation which uses {@link BodyConverter} and
 * {@link ErrorConverter} to handle <em>HTTP</em> response processing.
 */
public class DefaultResponseParser extends BaseResponseParser {
    private final BodyConverter bodyConverter;
    private final ErrorConverter errorConverter;

    public DefaultResponseParser(BodyConverter bodyConverter,
                                 ErrorConverter errorConverter) {
        Validate.notNull(bodyConverter);
        Validate.notNull(errorConverter);
        this.bodyConverter = bodyConverter;
        this.errorConverter = errorConverter;
    }

    @Override
    protected DataValue parseBody(String serviceId,
                                  String operationId,
                                  HttpResponse response) {
        return bodyConverter.getResult(serviceId, operationId, response);
    }

    @Override
    protected ErrorValue parseError(HttpResponse response) {
        return errorConverter.getError(response);
    }
}
