/* **********************************************************
 * Copyright (c) 2015-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

/**
 * Factory for creating {@link RequestBuilder} objects.
 */
public interface RequestBuilderFactory {

    /**
     * Creates {@link RequestBuilder} capable of building <em>REST</em> request for
     * invocation of given API operation.
     *
     * @param serviceId in <em>canonical</em> form; must not be {@code null}
     * @param operationId in <em>canonical</em> form; must not be {@code null}
     * @return request builder instance or {@code null} if such cannot be created
     */
    public RequestBuilder createRequestBuilder(String serviceId, String operationId);
}
