/* **********************************************************
 * Copyright (c) 2015-2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest.authn;

/**
 * Appends a standard oAuth authorization HTTP header to a specified HTTP
 * request.
 */
//TODO:
//- there is some OAuth support in vapi-rest but it is server side only; still need to
//unify/make this consistent with it
public class OauthAuthenticationAppender extends HeaderAuthenticationAppenderBase {
    @Override
    protected String getHeaderName() {
        return "Authorization";
    }

    @Override
    protected String getHeaderValue(String token) {
        return String.format("Bearer %s", token);
    }
}