/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vmware.vapi.protocol.HttpConfiguration.Header;
import com.vmware.vapi.protocol.HttpConfiguration.HeadersProvider;
import com.vmware.vapi.protocol.common.http.HttpConstants;

/**
 * Adapts {@link HeadersProvider} to an {@link HttpRequestInterceptor} so that
 * the headers specified in {@link HttpConfiguration} can be sent over the wire
 * with Apache's http-client.
 */
public class ApacheClientHeadersProvider implements HttpRequestInterceptor {
    private static Logger logger =
            LoggerFactory.getLogger(ApacheClientHeadersProvider.class);

    private HeadersProvider headersProvider;

    public ApacheClientHeadersProvider(HeadersProvider headersProvider) {
        this.headersProvider = headersProvider;
    }

    @Override
    public void process(HttpRequest request, HttpContext context)
            throws HttpException, IOException {
        Iterable<Header> headers = headersProvider.getHeaders();
        if (headers == null) {
           return;
        }

        for (Header header : headers) {
           String name = header.getName();
           if (HttpConstants.RESERVED_HEADERS.contains(name)) {
              logger.debug("HTTP {0} custom header won't be sent over the wire."
                           + " It is being used by the vAPI client.", header);
              continue;
           }

           request.addHeader(name, header.getValue());
        }
    }
}
