/* **********************************************************
 * Copyright (c) 2018 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http;

import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vmware.vapi.core.ExecutionContext.RuntimeData;

/**
 * Provides merging capability between Apache's {@link RequestConfig} and vAPI's
 * {@link RuntimeData}.
 */
public class ApacheClientRequestConfigurationMerger {
   private static Logger logger =
           LoggerFactory.getLogger(ApacheClientRequestConfigurationMerger.class);

   private final RequestConfig defaultRequestConfig;

   public ApacheClientRequestConfigurationMerger(
                                           RequestConfig defaultRequestConfig) {
      this.defaultRequestConfig = defaultRequestConfig;
   }

   /**
    * Merges the specified read-timeout with the default request configuration.
    *
    * @param readTimeout the read-timeout specific to a request
    * @return the resulting merged configuration if {@code readTimeout} is not
    *         null; otherwise, the default configuration.
    */
   public RequestConfig mergeWithDefaultConfig(Integer readTimeout) {
      if (defaultRequestConfig == null) {
         if (readTimeout != null) {
            logger.warn("Cannot set read-timeout due to predefined http-client");
         }
         return null;
      }

      if (readTimeout == null) {
         return defaultRequestConfig;
      }

      return RequestConfig.copy(defaultRequestConfig)
            .setSocketTimeout(readTimeout).build();
   }
}
