/* **********************************************************
 * Copyright (c) 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http.adapter;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;

/**
 * Adapter class supporting {@link HttpAsyncClientBuilder} proxy configuration.
 */
public class NioHttpClientBuilderAdapter implements
    ProxyAwareHttpClientBuilderAdapter {
    private final HttpAsyncClientBuilder builder;

    /**
     * Constructor.
     * @param builder is the adaptee instance
     */
    public NioHttpClientBuilderAdapter(HttpAsyncClientBuilder builder) {
        this.builder = builder;
    }

    @Override
    public ProxyAwareHttpClientBuilderAdapter setRoutePlanner(HttpRoutePlanner routePlanner) {
        builder.setRoutePlanner(routePlanner);
        return this;
    }

    @Override
    public ProxyAwareHttpClientBuilderAdapter setProxy(HttpHost proxy) {
        builder.setProxy(proxy);
        return this;
    }

    @Override
    public ProxyAwareHttpClientBuilderAdapter addInterceptorFirst(HttpRequestInterceptor itcp) {
        builder.addInterceptorFirst(itcp);
        return this;
    }
}