/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.common.http;

import java.io.IOException;

/**
 * Deserializer of binary frames.
 */
public interface FrameDeserializer {

    /**
     * Deserializes a binary frame from a stream.
     *
     * @param inp input from which to read the frame; must not be
     *            <code>null</code>
     * @return frame payload; <code>null</code> when there are no more frames
     *         to read from the stream
     * @throws IOException format error or propagate errors from the input
     *                     stream
     */
    byte[] readFrame(BinaryInput inp) throws IOException;
}
