/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.common.http;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Serializer of binary frames.
 */
public interface FrameSerializer {

    /**
     * Serializes a binary frame into a stream.
     *
     * @param out output stream where to serialize the frame; must not be
     *            <code>null</code>
     * @param frame binary payload; must not be <code>null</code>
     * @throws IOException propagate errors from the output stream
     */
    void writeFrame(OutputStream out, byte[] frame) throws IOException;
}
