/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.common.http.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

import com.vmware.vapi.internal.protocol.common.http.FrameSerializer;

/**
 * Frame deserializer which uses a format similar to HTTP chunked transfer
 * encoding. See {@link ChunkedTransferEncodingFrameDeserializer} for a
 * description of the format.
 */
public class ChunkedTransferEncodingFrameSerializer implements FrameSerializer {

    /**
     * ASCII charset.
     */
    private static final Charset ASCII = Charset.forName("US-ASCII");

    /**
     * ASCII encoding of a carriage return followed by a line feed.
     */
    private static final byte[] CRLF = "\r\n".getBytes(ASCII);

    @Override
    public void writeFrame(OutputStream out, byte[] frame) throws IOException {
        out.write(Integer.toHexString(frame.length).getBytes(ASCII));
        out.write(CRLF);
        out.write(frame);
        out.write(CRLF);
    }
}
