/* **********************************************************
 * Copyright 2012, 2022 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * JsonBaseResponse.java --
 *
 *      Super class to represent a JSON RPC 2.0 response.
 */

package com.vmware.vapi.internal.protocol.common.json;

public class JsonBaseResponse {
    private final String jsonrpc;
    private final String id;

    public JsonBaseResponse(String id) {
        this.id = id;
        this.jsonrpc = JsonConstants.JSON_RPC_VERSION;
    }

    public String getJsonrpc() {
        return jsonrpc;
    }

    public String getId() {
        return id;
    }

    public boolean isError() {
        return false;
    }
}
