/* **********************************************************
 * Copyright 2012 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * JsonConstants.java --
 *
 *      Class defining all the constants used by the JSON msg layer.
 */

package com.vmware.vapi.internal.protocol.common.json;

public final class JsonConstants {

    private JsonConstants() {}

    // JSON-RPC constants
    public static final String FIELD_JSONRPC = "jsonrpc";
    public static final String JSON_RPC_VERSION = "2.0";

    // JSON Request constants
    public static final String FIELD_SERVICE_ID = "serviceId";
    public static final String FIELD_OPERATION_ID = "operationId";
    public static final String FIELD_ID = "id";
    public static final String FIELD_METHOD = "method";
    public static final String FIELD_PARAMS = "params";
    public static final String CONTEXT = "ctx";
    public static final String APP_CTX = "appCtx";
    public static final String SEC_CTX = "securityCtx";
    public static final String INPUT = "input";
    public static final String SHOW_UNRELEASED_APIS = "$showUnreleasedAPIs";

    // JSON Response constants
    public static final String FIELD_RESULT = "result";

    // JSON Error constants
    public static final String JSON_ERROR_CODE = "code";
    public static final String JSON_ERROR_MESSAGE = "message";
    public static final String JSON_ERROR_DATA = "data";

    // MethodIdentifier constants
    public static final String METHOD_IDENTIFIER_NAME = "name";
    public static final String METHOD_IDENTIFIER_INTERFACE = "interfaceIdentifier";

    // MethodDefinition constants
    public static final String METHOD_DEFINITION_IDENTIFIER = "id";
    public static final String METHOD_DEFINITION_INPUT = "inputDefinition";
    public static final String METHOD_DEFINITION_OUTPUT = "outputDefinition";
    public static final String METHOD_DEFINITION_ERRORS = "errors";

    // InterfaceIdentifier constants
    public static final String INTERFACE_IDENTIFIER_NAME = "name";

    // InterfaceDefinition constants
    public static final String INTERFACE_DEFINITION_IDENTIFIER ="id";
    public static final String INTERFACE_DEFINITION_METHODIDEN = "methodIdentifiers";

    // ProviderDefinition constants
    public static final String PROVIDER_DEFINITION_IDENTIFIER = "id";

    public static enum RequestType {
        invoke
    }

}
