/* **********************************************************
 * Copyright 2012 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * JsonInvalidMethodException.java --
 *
 *      Exception class to denote an invalid JSON-RPC method.
 */

package com.vmware.vapi.internal.protocol.common.json;

public final class JsonInvalidMethodException extends Exception {
    /**
     * Generated
     */
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String jsonMethod;
    private final String message;

    /**
     * Constructor
     *
     * @param id ID of JSON-RPC 2.0 message
     * @param name of the invalid JSON-RPC method
     * @param message Name of method that is invalid along with
     *                any additional information
     */
    public JsonInvalidMethodException(String id, String jsonMethod, String message) {
        this.id = id;
        this.jsonMethod = jsonMethod;
        this.message = message;
    }

    public String getId() {
        return id;
    }

    public String getJsonMethod() {
        return this.jsonMethod;
    }

    public String getMsg() {
        return message;
    }
}
