/* **********************************************************
 * Copyright 2012-2013 VMware, Inc. All rights reserved.
 *      -- VMware Confidential
 * *********************************************************
 */

/*
 * JsonInvalidResponse.java --
 *
 *      Exception class to denote an invalid JSON response. This does not
 *      include JSON parse errors.
 */

package com.vmware.vapi.internal.protocol.common.json;

public final class JsonInvalidResponse extends Exception {
    /**
     * Generated
     */
    private static final long serialVersionUID = 1L;
    private final String message;
    private String jsonErrorCode;
    private String data;

    /**
     * Constructor
     *
     * @param message Reason why JSON request is invalid
     */
    public JsonInvalidResponse(String message) {
        this.message = message;
    }

    /**
     * Constructor
     *
     * @param message Reason why JSON request is invalid
     * @param jsonErrorCode JSON-RPC error code, or <code>null</code> if this
     *                      instance is not created for JSON-RPC error
     * @param data additional data about the JSON-RPC error
     */
    // TODO: this exception is reused for different error cases, need a
    //       separate one for JSON-RPC errors reported by the server
    public JsonInvalidResponse(String message,
                               String jsonErrorCode,
                               String data) {
        this.message = message;
        this.jsonErrorCode = jsonErrorCode;
        this.data = data;
    }

    public String getMessage() {
        return message;
    }

    public String getJsonErrorCode() {
        return this.jsonErrorCode;
    }

    public String getData() {
        return data;
    }
}

