/* **********************************************************
 * Copyright 2013, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ApiIntrospectionMethodBase.java --
 *
 *      Base ApiMethod implementation.
 */
package com.vmware.vapi.internal.provider.introspection;

import java.util.Set;

import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.provider.introspection.ApiIntrospection;

/**
 * Base {@link ApiMethod} implementation.
 */
abstract class ApiIntrospectionMethodBase implements ApiMethod {
    private final MethodDefinition methodDef;
    protected final ApiIntrospection introspection;


    protected ApiIntrospectionMethodBase(MethodIdentifier methodId,
                                          DataDefinition inputDef,
                                          DataDefinition outputDef,
                                          Set<ErrorDefinition> errorDefs,
                                          ApiIntrospection introspection) {
        Validate.notNull(methodId);
        Validate.notNull(inputDef);
        Validate.notNull(outputDef);
        Validate.notNull(introspection);
        methodDef = new MethodDefinition(methodId,
                                         inputDef,
                                         outputDef,
                                         errorDefs);
        this.introspection = introspection;
    }

    @Override
    public MethodIdentifier getIdentifier() {
        return methodDef.getIdentifier();
    }

    @Override
    public MethodDefinition getDefinition() {
        return methodDef;
    }

    @Override
    public DataDefinition getInputDefinition() {
        return methodDef.getInputDefinition();
    }

    @Override
    public DataDefinition getOutputDefinition() {
        return methodDef.getOutputDefinition();
    }
}

