/* **********************************************************
 * Copyright 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.tracing.otel;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.opentelemetry.api.OpenTelemetry;

/**
 * Checks if opentelemetry is on the classpath
 */
// FIXME only used by TracingAttributeKey - fix TracingAttributeKey and remove
// this class
public class OtelFeature {
    private static final Logger logger = LoggerFactory.getLogger(OtelFeature.class);
    static boolean ON = classesLoaded();

    public static boolean isEnabled() {
        return ON;
    }

    private static boolean classesLoaded() {
        try {
            OpenTelemetry.noop();
            logger.debug("OpenTelemetry is on the classpath");
            return true;
        } catch (Exception | NoClassDefFoundError e) {
            logger.info("OpenTelemetry is not on the classpath");
            logger.debug("Failed to load OpenTelemetry", e);
            return false;
        }
    }
}