/* **********************************************************
 * Copyright 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.tracing.otel;

import java.util.Collections;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import io.opentelemetry.context.propagation.TextMapGetter;

/**
 * A {@link TextMapGetter} adapter that can read the trace id header from an
 * {@link HttpServletRequest}
 */
class TracingRequestAdapter implements TextMapGetter<HttpServletRequest> {

    @Override
    public Iterable<String> keys(HttpServletRequest request) {
        Enumeration<String> names = request.getHeaderNames();
        if (names == null) {
            return Collections.emptyList();
        }
        Iterable<String> headers = Collections.list(names);
        return headers;
    }

    @Override
    public String get(HttpServletRequest request, String key) {
        return request.getHeader(key);
    }
}
