/* **********************************************************
 * Copyright 2014 VMware, Inc. All rights reserved.
 *      -- VMware Confidential
 * *********************************************************
 */
package com.vmware.vapi.internal.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * ThreadFactory implementation that allows configuring thread names.
 * Thread names are prefix + n, where n in incremented.
 */
public class DefaultThreadFactory implements ThreadFactory {

    private final String prefix;
    private final AtomicInteger threadCount;

    /**
     * Constructor
     *
     * @param prefix the prefix for thread names.
     */
    public DefaultThreadFactory(String prefix) {
        this.prefix = prefix;
        this.threadCount = new AtomicInteger();
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(r, prefix + threadCount.getAndIncrement());
    }
}
