/* **********************************************************
 * Copyright (c) 2017 VMware, Inc. All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.util;

import com.vmware.vapi.bindings.server.InvocationContext;

/**
 * Utility to support Task API invocation.
 */
public class TaskUtil {
    public static final String TASK = "$task";

    /**
     * If the given invocation is a task-invocation
     *
     * @param ctx invocation context
     *
     * @return boolean
     */
    public static boolean isTaskInvocation(final InvocationContext ctx) {
        return ctx.isTask();
    }

    /**
     * If the invocation for the given method name is a task-invocation
     *
     * @param methodName name of the operation
     *
     * @return boolean
     */
    public static boolean isTaskInvocation(final String methodName) {
        return methodName.endsWith(TASK);
    }
}
