/* **********************************************************
 * Copyright (c) 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.protocol;

import com.vmware.vapi.internal.util.Validate;

/**
 * Represents user and password credentials.
 */
public class UserPassCredentials {
    private String user;
    private char[] password;

    /**
     * Constructor.
     * @param user is the user; must not be {@code null}
     * @param password is the password; must not be {@code null}
     */
    public UserPassCredentials(String user, char[] password) {
        Validate.notNull(user);
        Validate.notNull(password);
        this.user = user;
        this.password = password;
    }

    /**
     * @return a username
     */
    public String getUser() {
        return user;
    }

    /**
     * @return a password
     */
    public char[] getPassword() {
        return password;
    }
}