/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.common.json;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.data.DataValue;

/**
 * JSON-RPC serializer for {@code DataValue}s.
 *
 * <p>This serializer uses JSON representations for {@code DataValue} instances
 * which matches the wire format used for the vAPI JSON-RPC protocol. This
 * format guarantees precise match with the original when arbitrary
 * {@code DataValue} representation is deserialized.
 */
public interface JsonRpcSerializer {

    /**
     * Serializes the provided {@code DataValue} as JSON.
     *
     * @param dataValue to be serialized
     * @return serialized JSON as {@code String}
     * @throws CoreException if the provided {@code dataValue} cannot be
     *         serialized
     */
    String serializeDataValue(DataValue dataValue);
}
