/* **********************************************************
 * Copyright 2011-2012 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * LocalConnection.java --
 *
 *      Connection in the same process.
 */

package com.vmware.vapi.protocol.local;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ApiProviderStub;
import com.vmware.vapi.core.ApiProviderStubImpl;
import com.vmware.vapi.protocol.ProtocolConnection;

/**
 * Fake connection used to call only if in the same process.
 */
public class LocalConnection implements ProtocolConnection {

    private LocalProtocol localProtocol;

    public LocalConnection(LocalProtocol localProtocol) {
        if (localProtocol == null) {
            throw new IllegalArgumentException("Local protocol is required.");
        }
        this.localProtocol = localProtocol;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public ApiProvider getApiProvider() {
        return localProtocol.getApiProvider();
    }

    @Override
    public ApiProviderStub getApiProviderStub() {
        return new ApiProviderStubImpl(getApiProvider());
    }
}
