/* **********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.protocol.server.rpc.http;

import java.util.List;

/**
 * Interface that provide common mechanism for life cycle management of tasks
 * and threads.<br>
 * The classes that implements this interface are supposed to support shutdown
 * of {@link LifecycleListener} items.
 */
public interface LifecycleManager extends LifecycleListener {
   /**
    * Add single life {@link LifecycleListener} to the end of the
    * {@link LifecycleListener} listeners list.
    *
    * @param lifecycleListener
    *           {@link LifecycleListener} item to be added.
    */
   public void addLifecycleListener(LifecycleListener lifecycleListener);

   /**
    * Sets a {@link List} of {@link LifecycleListener} listener items that
    * should be managed. The order that the items will be managed is the same as
    * they are passed. If there are already added items with
    * {@link LifecycleManager#addLifecycleListener(LifecycleListener)} they
    * are removed from the list.
    *
    * @param lifecycleListeners
    *           list of {@link LifecycleListener} items.
    */
   public void setLifecycleListeners(List<LifecycleListener> lifecycleListeners);
}