/* **********************************************************
 * Copyright 2009-2016 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.server.rpc.http;


/**
 * An SSL endpoint.
 */

public interface SslEndpoint extends Endpoint {
   /**
    * Returns keystore type
    */
   public String getKeyStoreType();

   /**
    * Returns the path to the keystore.
    * @return The path to the keystore.
    */
   public String getKeyStorePath();

   /**
    * Returns the keystore password.
    * @return The keystore password;
    */
   public String getKeyStorePassword();

   /**
    * Returns the alias of the key/cert pair to use for this endpoint.
    * This value may not be configurable for some implementations.
    * For example, the Jetty SSL connectors will always look for a
    * key/cert pairs whose alias is "jetty".
    * @return The alias of the key/cert pair to use for this endpoint.
    */
   public String getKeyAlias();

   /**
    * Returns the key password.
    * @return The key password;
    */
   public String getKeyPassword();

   /**
    * Returns the path to the trust store.
    * @return The path to the trust store.  May be null if no trust
    * store is configured.
    */
   public String getTrustStorePath();

   /**
    * Returns the trust store password.
    * @return The trust store password.  May be null if no trust store
    * is configured.
    */
   public String getTrustStorePassword();

   /**
    * Sets whether the server will require the client to
    * authenticate with certificate.
    * @param needed true if authentication is needed
    */
   public void setNeedClientAuth(boolean needed);

   /**
    * Sets whether the server will desire the client to
    * authenticate with certificate.
    * @param wanted true if authentication is desired
    */
   public void setWantClientAuth(boolean wanted);

   /**
    * Gets whether server requires the client to authenticate
    * with certificate.
    * @return true if client must provide certificate
    */
   public boolean getNeedClientAuth();

   /**
    * Gets whether server desires the client to authenticate
    * with certificate.
    * @return true if client may provide certificate
    */
   public boolean getWantClientAuth();

   /**
    * Gets the list of protocols that are enabled for use by SSL connections.
    *
    * @return list of protocols enabled to use by SSL connections.
    */
   public String getEnabledProtocols();
}
