/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.protocol.server.rpc.http.impl;

import java.util.Map;

import com.vmware.vapi.protocol.server.rpc.http.Filter;

public class FilterImpl implements Filter {
   private static final Dispatcher[] DEFAULT_DISPATCHERS =
      new Dispatcher[] {Dispatcher.REQUEST};

   private Dispatcher[] _dispatchers = DEFAULT_DISPATCHERS;
   private String _path;
   private javax.servlet.Filter _filter;
   private Map<String, String> _params;

   @Override
   public Dispatcher[] getDispatchers() {
      return _dispatchers;
   }

   @Override
   public void setDispatchers(Dispatcher[] dispatchers) {
      _dispatchers = dispatchers;
   }

   @Override
   public String getPath() {
      return _path;
   }

   @Override
   public void setPath(String path) {
      _path = path;
   }

   @Override
   public javax.servlet.Filter getFilter() {
      return _filter;
   }

   @Override
   public void setFilter(javax.servlet.Filter filter) {
      _filter = filter;
   }

   @Override
   public Map<String, String> getInitParameters() {
      return _params;
   }

   @Override
   public void setInitParameters(Map<String, String> params) {
      _params = params;
   }
}
