/* **********************************************************
 * Copyright 2011, 2015, 2017 VMware, Inc. All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.provider;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataValue;

/**
 * The <code>ApiMethod</code> interface provides introspection
 * and invocation APIs for a vAPI method; it is implemented by
 * API providers.
 */
public interface ApiMethod {

    /**
     * Returns the identifier for this method.
     *
     * @return          method identifier for this method
     */
    public MethodIdentifier getIdentifier();

    /**
     * Returns the definition for this method.
     *
     * @return          the definition of this method
     */
    public MethodDefinition getDefinition();

    /**
     * Returns the data definition for the input of this method.
     *
     * @return          data definition for the method input
     */
    public DataDefinition getInputDefinition();

    /**
     * Returns the data definition for the output of this method.
     *
     * @return          data definition for the method output
     */
    public DataDefinition getOutputDefinition();

    /**
     * Invokes a method and returns the result of that method invocation.
     *
     * @param ctx          invocation context for method invocation
     * @param input        input data value
     * @param asyncHandle  handle used to return result or error
     */
    public void invoke(InvocationContext ctx,
                       DataValue input,
                       AsyncHandle<MethodResult> asyncHandle);
}