/* **********************************************************
 * Copyright 2013 VMware, Inc. All rights reserved.
 *      -- VMware Confidential
 * *********************************************************
 */

/*
 * ApiIntrospection.java --
 *
 *      Interface for API Introspection.
 */

package com.vmware.vapi.provider.introspection;

import java.util.Set;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.ProviderDefinition;

/**
 * Interface for API Introspection.
 */
public interface ApiIntrospection {

    /**
     * Returns the definition for this API provider.
     *
     * @param ctx          execution context for the invocation
     * @param asyncHandle  handle used to return result or error
     */
    public void getDefinition(ExecutionContext ctx,
            AsyncHandle<ProviderDefinition> asyncHandle);

    /**
     * Returns the set of interface identifiers supported by this provider.
     *
     * @param ctx          execution context for the invocation
     * @param asyncHandle  handle used to return result or error
     */
    public void getInterfaceIdentifiers(ExecutionContext ctx,
            AsyncHandle<Set<InterfaceIdentifier>> asyncHandle);

    /**
     * Returns interface definition for a given interface identifier.
     *
     * @param ctx          execution context for the invocation
     * @param ifaceId      interface identifier
     * @param asyncHandle  handle used to return result or error
     */
    public void getInterface(ExecutionContext ctx,
            InterfaceIdentifier ifaceId,
            AsyncHandle<InterfaceDefinition> asyncHandle);

    /**
     * Returns method definitions for a given method identifier. or
     * <code>null</code> if no such method is available
     *
     * @param ctx          execution context for the invocation
     * @param methodId     method identifier
     * @param asyncHandle  handle used to return result or error
     */
    public void getMethod(ExecutionContext ctx,
            MethodIdentifier methodId,
            AsyncHandle<MethodDefinition> asyncHandle);
}
