/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.provider.introspection;

import java.util.Set;

import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.ProviderDefinition;

/**
 * Client-side stub for the introspection services exposed by a provider.
 */
public interface ApiIntrospectionStub extends ApiIntrospection,
        SyncApiIntrospection {

    /**
     * Returns the definition for this API provider.
     *
     * @return definition for this provider
     */
    public ProviderDefinition getDefinition();

    /**
     * Returns the set of interface identifiers supported by this provider.
     *
     * @return set of identifiers
     */
    public Set<InterfaceIdentifier> getInterfaceIdentifiers();

    /**
     * Returns interface definition for a given interface identifier.
     *
     * @param ifaceId   interface identifier
     * @return          interface definition for the given interface identifier
     */
    public InterfaceDefinition getInterface(InterfaceIdentifier ifaceId);

    /**
     * Returns method definitions for a given method identifier. or
     * <code>null</code> if no such method is available
     *
     * @param methodId     method identifier
     * @return <code>MethodDefinition</code> instance or <code>null</code>
     *         is not found for the specified identifier
     */
    public MethodDefinition getMethod(MethodIdentifier methodId);
}
