/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std;

/**
 * The {@link com.vmware.vapi.std.AuthenticationScheme} class defines constants for
 * authentication scheme identifiers for authentication mechanisms present in the
 * vAPI infrastructure shipped by VMware. 
 * <p> A third party extension can define
 * and implements it's own authentication mechanism and define a constant in a
 * different IDL file.</p>
 */
public final class AuthenticationScheme implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Indicates that the request doesn't need any authentication.
     */
    public static final java.lang.String NO_AUTHENTICATION = "com.vmware.vapi.std.security.no_authentication";

    /**
     * Indicates that the security context in a request is using a SAML bearer token
     * based authentication scheme. 
     * <p> In this scheme, the following pieces of
     * information has to be passed in the SecurityContext structure in the execution
     * context of the request: </p><ul> <li>The scheme identifier:
     * com.vmware.vapi.std.security.saml_bearer_token</li> <li>The token itself</li>
     * </ul> 
     * <p> Sample security context in JSON format that matches the
     * specification: {@code {
     * 'schemeId':
     * 'com.vmware.vapi.std.security.saml_bearer_token',
     * 'token': 'the token itself'
     * }}
     * vAPI runtime provide convenient factory methods that take SAML bearer token and
     * to create the security context that conforms to the above mentioned format.</p>
     */
    public static final java.lang.String SAML_BEARER_TOKEN = "com.vmware.vapi.std.security.saml_bearer_token";

    /**
     * Indicates that the security context in a request is using a SAML holder-of-key
     * token based authentication scheme. 
     * <p> In this scheme, the following pieces of
     * information has to be passed in the SecurityContext structure in the execution
     * context of the request: </p><ul> <li>The scheme identifier:
     * com.vmware.vapi.std.security.saml_hok_token</li> <li>Signature of the request:
     * This includes - algorithm used for signing the request, SAML holder of key token
     * and signature digest </li> <li>Request timestamp: This includes the {@code
     * created} and {@code expires} timestamp of the request. The timestamp should
     * match the following format - YYYY-MM-DDThh:mm:ss.sssZ (e.g.
     * 1878-03-03T19:20:30.451Z). </li></ul> 
     * <p> Sample security context in JSON
     * format that matches the specification: {@code {
     * 'schemeId':
     * 'com.vmware.vapi.std.security.saml_hok_token',
     * 'signature': {
     * 'alg':
     * 'RS256',
     * 'samlToken': ...,
     * 'value': ...,}, 'timestamp': { 'created':
     * '2012-10-26T12:24:18.941Z', 'expires': '2012-10-26T12:44:18.941Z', } } } vAPI
     * runtime provide convenient factory methods that take SAML holder of key token
     * and private key to create the security context that conforms to the above
     * mentioned format.</p>
     */
    public static final java.lang.String SAML_HOK_TOKEN = "com.vmware.vapi.std.security.saml_hok_token";

    /**
     * Indicates that the security context in a request is using a session identifier
     * based authentication scheme. 
     * <p> In this scheme, the following pieces of
     * information has to be passed in the SecurityContext structure in the execution
     * context of the request: </p><ul> <li>The scheme identifier -
     * com.vmware.vapi.std.security.session_id</li> <li>Valid session identifier - This
     * is usually returned by a login method of a session manager interface for a
     * particular vAPI service of this authentication scheme</li> </ul> Sample security
     * context in JSON format that matches the specification: {@code {
     * 'schemeId':
     * 'com.vmware.vapi.std.security.session_id',
     * 'sessionId': ....,
     * }} vAPI runtime
     * provides convenient factory methods that take session identifier as input
     * parameter and create a security context that conforms to the above format.
     */
    public static final java.lang.String SESSION_ID = "com.vmware.vapi.std.security.session_id";

    /**
     * Indicates that the security context in a request is using username/password
     * based authentication scheme. 
     * <p> In this scheme, the following pieces of
     * information has to be passed in the SecurityContext structure in the execution
     * context of the request: </p><ul> <li>The scheme identifier -
     * com.vmware.vapi.std.security.user_pass</li> <li>Username</li> <li>Password</li>
     * </ul> 
     * <p> Sample security context in JSON format that matches the
     * specification: {@code {
     * 'schemeId':
     * 'com.vmware.vapi.std.security.user_pass',
     * 'userName': ....,
     * 'password': ...
     * }}
     * <br/> vAPI runtime provides convenient factory methods that take username and
     * password as input parameters and create a security context that conforms to the
     * above format.</p>
     */
    public static final java.lang.String USER_PASSWORD = "com.vmware.vapi.std.security.user_pass";

    /**
     * Indicates that the security context in a request is using OAuth2 based
     * authentication scheme. 
     * <p> In this scheme, the following pieces of information
     * has to be passed in the SecurityContext structure in the execution context of
     * the request: </p><ul> <li>The scheme identifier -
     * com.vmware.vapi.std.security.oauth</li> <li>Valid OAuth2 access token - This is
     * usually acquired by OAuth2 Authorization Server after successful authentication
     * of the end user.</li> </ul> 
     * <p> Sample security context in JSON format that
     * matches the specification: {@code {
     * 'schemeId':
     * 'com.vmware.vapi.std.security.oauth',
     * 'accesstoken': ....
     * }} <br/> vAPI runtime
     * provides convenient factory methods that takes OAuth2 access token as input
     * parameter and creates a security context that conforms to the above format.</p>
     */
    public static final java.lang.String OAUTH_ACCESS_TOKEN = "com.vmware.vapi.std.security.oauth";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public AuthenticationScheme() {
    }

    protected AuthenticationScheme(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.vapi.std.StructDefinitions.authenticationScheme;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.vapi.std.StructDefinitions.authenticationScheme;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.StructDefinitions.authenticationScheme.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static AuthenticationScheme _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new AuthenticationScheme(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static AuthenticationScheme _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new AuthenticationScheme(structValue);
    }

    /**
     * Builder class for {@link AuthenticationScheme}.
     */
    public static final class Builder {

        /**
         * Constructor with parameters for the required properties of
         * {@link AuthenticationScheme}.
         */
        public Builder() {
        }

        public AuthenticationScheme build() {
            AuthenticationScheme result = new AuthenticationScheme();
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.authentication_scheme",
                                                            fields,
                                                            com.vmware.vapi.std.AuthenticationScheme.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

