
/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


/**
 * The {@code com.vmware.vapi.std} package provides standard types that can be used
 * in the interface specification of any interface.
 */
package com.vmware.vapi.std;

/**
 * {@link StdFactory} is responsible for creating instances of services
 * contained inside the com.vmware.vapi.std package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class StdFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private StdFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link StdFactory} factory instance
     */
    public static StdFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        StdFactory instance = new StdFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * The {@code com.vmware.vapi.std.activation} package provides interfaces that
     * TODO.
     */
    public com.vmware.vapi.std.activation.ActivationFactory activation() {
        return com.vmware.vapi.std.activation.ActivationFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    /**
     * The {@code com.vmware.vapi.std.errors} package provides the standard exceptions
     * that can be included in the list of exceptions in the specification of methods
     * to indicate that the method might report those exceptions. 
     * <p> It also provides
     * some classes intended to be used as payload to provide additional information
     * about those exceptions.</p>
     */
    public com.vmware.vapi.std.errors.ErrorsFactory errors() {
        return com.vmware.vapi.std.errors.ErrorsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    /**
     * The {@code com.vmware.vapi.std.interposition} package provides interfaces that
     * TODO.
     */
    public com.vmware.vapi.std.interposition.InterpositionFactory interposition() {
        return com.vmware.vapi.std.interposition.InterpositionFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    /**
     * The {@link com.vmware.vapi.std.introspection} package provides interfaces that
     * expose basic information about the vAPI interfaces registered with a vAPI
     * provider.
     */
    public com.vmware.vapi.std.introspection.IntrospectionFactory introspection() {
        return com.vmware.vapi.std.introspection.IntrospectionFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
