/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.vapi.std.activation.
 * Used by client-side stubs.
 */

package com.vmware.vapi.std.activation;

/**
 * <b>WARNING:</b> Use only as a sample. The API is experimental and subject to
 * change in future versions. 
 * <p> Activation tracking/management service. </p>
 * <p>
 * An activation describes a method invocation in the runtime.</p>
 */
public interface ActivationManager extends com.vmware.vapi.bindings.Service, com.vmware.vapi.std.activation.ActivationManagerTypes {

    /**
     * Asks for cancellation of a running activation. Whether or not the cancellation
     * request will have any effect depends on the implementation of the method that
     * has to be canceled.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param activationId activation identifier
     * @throws com.vmware.vapi.std.errors.NotFound there is no activation with the specified id
     */
    public void cancel(java.lang.String activationId);

    /**
     * Asks for cancellation of a running activation. Whether or not the cancellation
     * request will have any effect depends on the implementation of the method that
     * has to be canceled.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param activationId activation identifier
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.NotFound there is no activation with the specified id
     */
    public void cancel(java.lang.String activationId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Asks for cancellation of a running activation. Whether or not the cancellation
     * request will have any effect depends on the implementation of the method that
     * has to be canceled.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - there is no activation with the specified id<br>
     * </p>
     *
     * @param activationId activation identifier
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void cancel(java.lang.String activationId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Asks for cancellation of a running activation. Whether or not the cancellation
     * request will have any effect depends on the implementation of the method that
     * has to be canceled.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - there is no activation with the specified id<br>
     * </p>
     *
     * @param activationId activation identifier
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void cancel(java.lang.String activationId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
