
/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.activation.
 */

package com.vmware.vapi.std.activation;

/**
 * Implementation of {@link com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton} which
 * adapts API service implementation (class that implements
 * the generated {@link com.vmware.vapi.std.activation.ActivationManagerSyncProvider} interface).
 *
 * <p>This adapter expects synchronous API service implementation.</p>
 */
public class ActivationManagerSyncApiInterface extends com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton {
    private com.vmware.vapi.std.activation.ActivationManagerSyncProvider impl;

    private class CancelApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public CancelApiMethod() {
            super(ActivationManagerSyncApiInterface.this.getIdentifier(),
                  "cancel", com.vmware.vapi.std.activation.ActivationManagerDefinitions.__cancelInput,
                  com.vmware.vapi.std.activation.ActivationManagerDefinitions.__cancelOutput,
                  getTypeConverter(),
                  java.util.Arrays.<com.vmware.vapi.bindings.type.Type>asList(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.errors.StructDefinitions.notFound; } }),
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            com.vmware.vapi.internal.bindings.StructValueExtractor extr =
                    new com.vmware.vapi.internal.bindings.StructValueExtractor(inStruct,
                                                                               com.vmware.vapi.std.activation.ActivationManagerDefinitions.__cancelInput,
                                                                               getTypeConverter());
            java.lang.String activationId = extr.<java.lang.String>valueForField("activation_id");
            try {
                impl.cancel(activationId, invocationContext);
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newResult(com.vmware.vapi.data.VoidValue.getInstance()));
            } catch (java.lang.RuntimeException ex) {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newErrorResult(toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }

    /**
     * Constructor.
     *
     * Creates an {@link ActivationManagerSyncApiInterface} instance with
     * default API service implementation.
     * <p>
     * The default service implementation is assumed to be
     * instance of the {@code com.vmware.vapi.std.activation.impl.ActivationManagerImpl} class. This
     * class will be loaded and instantiated.
     */
    public ActivationManagerSyncApiInterface() {
        this((java.lang.Class<com.vmware.vapi.std.activation.ActivationManagerSyncProvider>) null);
    }

    /**
     * Constructor.
     *
     * Creates an {@link ActivationManagerSyncApiInterface} instance
     * for specified {@code class} of the API service implementation. The
     * specified class will be instantiated.
     *
     * @param implClass The {@code Class} implementing {@link com.vmware.vapi.std.activation.ActivationManagerSyncProvider}
     *                  API service. If {@code null} default implementation will be
     *                  used as in {@link #ActivationManagerSyncApiInterface()}.
     */
    public ActivationManagerSyncApiInterface(java.lang.Class<? extends com.vmware.vapi.std.activation.ActivationManagerSyncProvider> implClass) {
        this(createImplInstance(implClass,
                                "com.vmware.vapi.std.activation.impl.ActivationManagerImpl",
                                com.vmware.vapi.std.activation.ActivationManagerSyncProvider.class));
    }

    /**
     * Constructor.
     *
     * Creates an {@link ActivationManagerSyncApiInterface} instance
     * for specified instance of the API service implementation.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.activation.ActivationManagerSyncProvider}
     *             API service. Must not be {@code null}.
     */
    public ActivationManagerSyncApiInterface(com.vmware.vapi.std.activation.ActivationManagerSyncProvider impl) {
        this(impl,  new com.vmware.vapi.internal.bindings.TypeConverterImpl());
    }

    /**
     * Constructor.
     *
     * Creates an {@link ActivationManagerSyncApiInterface} instance
     * for specified instance of the API service implementation and custom conversion logic.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.activation.ActivationManagerSyncProvider}
     *             API service. Must not be {@code null}.
     * @param converter logic to convert from native to wire type and back. Must not be {@code null}.
     */
    public ActivationManagerSyncApiInterface(com.vmware.vapi.std.activation.ActivationManagerSyncProvider impl,
            com.vmware.vapi.internal.bindings.TypeConverter converter) {
        super("com.vmware.vapi.std.activation.activation_manager", converter);

        com.vmware.vapi.internal.util.Validate.notNull(impl);
        this.impl = impl;

        registerMethod(new CancelApiMethod());
   }
}

