
/*
 * Copyright 2022 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 */

package com.vmware.vapi.std.introspection;

/**
 * Implementation of {@link com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton} which
 * adapts API service implementation (class that implements
 * the generated {@link com.vmware.vapi.std.introspection.ServiceSyncProvider} interface).
 *
 * <p>This adapter expects synchronous API service implementation.</p>
 */
public class ServiceSyncApiInterface extends com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton {
    private com.vmware.vapi.std.introspection.ServiceSyncProvider impl;

    private class ListApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public ListApiMethod() {
            super(ServiceSyncApiInterface.this.getIdentifier(),
                  "list", com.vmware.vapi.std.introspection.ServiceDefinitions.__listInput,
                  com.vmware.vapi.std.introspection.ServiceDefinitions.__listOutput,
                  getTypeConverter(),
                  null,
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newResult(getTypeConverter().convertToVapi(impl.list(invocationContext),
                                                                                                                   com.vmware.vapi.std.introspection.ServiceDefinitions.__listOutput,
                                                                                                                   new com.vmware.vapi.internal.bindings.TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            } catch (java.lang.RuntimeException ex) {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newErrorResult(toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }

    private class GetApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public GetApiMethod() {
            super(ServiceSyncApiInterface.this.getIdentifier(),
                  "get", com.vmware.vapi.std.introspection.ServiceDefinitions.__getInput,
                  com.vmware.vapi.std.introspection.ServiceDefinitions.__getOutput,
                  getTypeConverter(),
                  java.util.Arrays.<com.vmware.vapi.bindings.type.Type>asList(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.errors.StructDefinitions.notFound; } }),
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            com.vmware.vapi.internal.bindings.StructValueExtractor extr =
                    new com.vmware.vapi.internal.bindings.StructValueExtractor(inStruct,
                                                                               com.vmware.vapi.std.introspection.ServiceDefinitions.__getInput,
                                                                               getTypeConverter());
            java.lang.String id = extr.<java.lang.String>valueForField("id");
            try {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newResult(getTypeConverter().convertToVapi(impl.get(id, invocationContext),
                                                                                                                   com.vmware.vapi.std.introspection.ServiceDefinitions.__getOutput,
                                                                                                                   new com.vmware.vapi.internal.bindings.TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            } catch (java.lang.RuntimeException ex) {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newErrorResult(toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }

    /**
     * Constructor.
     *
     * Creates an {@link ServiceSyncApiInterface} instance with
     * default API service implementation.
     * <p>
     * The default service implementation is assumed to be
     * instance of the {@code com.vmware.vapi.std.introspection.impl.ServiceImpl} class. This
     * class will be loaded and instantiated.
     */
    public ServiceSyncApiInterface() {
        this((java.lang.Class<com.vmware.vapi.std.introspection.ServiceSyncProvider>) null);
    }

    /**
     * Constructor.
     *
     * Creates an {@link ServiceSyncApiInterface} instance
     * for specified {@code class} of the API service implementation. The
     * specified class will be instantiated.
     *
     * @param implClass The {@code Class} implementing {@link com.vmware.vapi.std.introspection.ServiceSyncProvider}
     *                  API service. If {@code null} default implementation will be
     *                  used as in {@link #ServiceSyncApiInterface()}.
     */
    public ServiceSyncApiInterface(java.lang.Class<? extends com.vmware.vapi.std.introspection.ServiceSyncProvider> implClass) {
        this(createImplInstance(implClass,
                                "com.vmware.vapi.std.introspection.impl.ServiceImpl",
                                com.vmware.vapi.std.introspection.ServiceSyncProvider.class));
    }

    /**
     * Constructor.
     *
     * Creates an {@link ServiceSyncApiInterface} instance
     * for specified instance of the API service implementation.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.ServiceSyncProvider}
     *             API service. Must not be {@code null}.
     */
    public ServiceSyncApiInterface(com.vmware.vapi.std.introspection.ServiceSyncProvider impl) {
        this(impl,  new com.vmware.vapi.internal.bindings.TypeConverterImpl());
    }

    /**
     * Constructor.
     *
     * Creates an {@link ServiceSyncApiInterface} instance
     * for specified instance of the API service implementation and custom conversion logic.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.ServiceSyncProvider}
     *             API service. Must not be {@code null}.
     * @param converter logic to convert from native to wire type and back. Must not be {@code null}.
     */
    public ServiceSyncApiInterface(com.vmware.vapi.std.introspection.ServiceSyncProvider impl,
            com.vmware.vapi.internal.bindings.TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.service", converter);

        com.vmware.vapi.internal.util.Validate.notNull(impl);
        this.impl = impl;

        registerMethod(new ListApiMethod());
        registerMethod(new GetApiMethod());
   }
}

