/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.BioFramedResponseHandlingStrategy;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.BioResponseHandlingStrategy;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.BioSingleResponseHandlingStrategy;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.BioStreamingResponseHandlingStrategy;
import java.io.IOException;
import java.io.InputStream;

public class BioResponseContentHandler {
    private String contentType;
    private CorrelatingClient.ResponseCallback cb;
    private BioResponseHandlingStrategy handleStrategy;

    public BioResponseContentHandler(String contentType, CorrelatingClient.ResponseCallback cb) {
        this.contentType = contentType;
        this.cb = cb;
        this.handleStrategy = this.createStrategy();
    }

    private BioResponseHandlingStrategy createStrategy() {
        switch (this.contentType) {
            case "application/vnd.vmware.vapi.stream.json": {
                return new BioStreamingResponseHandlingStrategy();
            }
            case "application/vnd.vmware.vapi.framed": {
                return new BioFramedResponseHandlingStrategy();
            }
        }
        return new BioSingleResponseHandlingStrategy();
    }

    public void handleResposne(InputStream content, AbortHandle abortHandle, String uri) throws IOException {
        this.handleStrategy.handleContent(content, this.cb, abortHandle, uri);
    }
}

