/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeRequestParams2;
import com.vmware.vapi.internal.security.SecurityUtil;
import java.util.HashMap;
import java.util.Map;

public class JsonContextBuilderRequestParams
extends JsonInvokeRequestParams2 {
    private final ExecutionContextBuilder ctxBuilder;

    JsonContextBuilderRequestParams(String serviceId, String operationId, ExecutionContextBuilder ctxBuilder, DataValue input) {
        super(serviceId, operationId, null, input);
        this.ctxBuilder = ctxBuilder;
    }

    @Override
    public ExecutionContext getCtx() {
        return this.ctxBuilder.view();
    }

    public ExecutionContextBuilder getCtxBuilder() {
        return this.ctxBuilder;
    }

    public static class ExecutionContextBuilder {
        public final Map<String, Object> security = new HashMap<String, Object>();
        public final Map<String, String> applicationData = new HashMap<String, String>();
        private final LazyExecutionContext lazyCtx = new LazyExecutionContext();

        public ExecutionContext build() {
            ExecutionContext.ApplicationData appData = new ExecutionContext.ApplicationData(this.applicationData);
            ExecutionContext.SecurityContext secCtx = this.security.isEmpty() ? null : SecurityUtil.createDefaultSecurityContext(this.security);
            return new ExecutionContext(appData, secCtx);
        }

        public ExecutionContext view() {
            return this.lazyCtx;
        }

        private class LazyExecutionContext
        extends ExecutionContext {
            private static final long serialVersionUID = 1L;

            private LazyExecutionContext() {
            }

            @Override
            public ExecutionContext.ApplicationData retrieveApplicationData() {
                return new ExecutionContext.ApplicationData(ExecutionContextBuilder.this.applicationData);
            }

            @Override
            public ExecutionContext.SecurityContext retrieveSecurityContext() {
                return ExecutionContextBuilder.this.security.isEmpty() ? null : SecurityUtil.createDefaultSecurityContext(ExecutionContextBuilder.this.security);
            }
        }
    }
}

