/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util.async;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.data.DataValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrictAsyncHandle<T>
extends AsyncHandle<T> {
    private static final Logger logger = LoggerFactory.getLogger(StrictAsyncHandle.class);
    private final AsyncHandle<T> decorated;
    private Object lock = new Object();
    private boolean completed = false;
    private StackTraceElement[] completedAt;

    public StrictAsyncHandle(AsyncHandle<T> decorated) {
        this.decorated = decorated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProgress(DataValue progress) {
        Object object = this.lock;
        synchronized (object) {
            this.assertNotCompleted();
            this.decorated.updateProgress(progress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResult(T result) {
        Object object = this.lock;
        synchronized (object) {
            this.assertNotCompleted();
            this.decorated.setResult(result);
            this.markCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setError(RuntimeException error) {
        Object object = this.lock;
        synchronized (object) {
            this.assertNotCompleted();
            this.decorated.setError(error);
            this.markCompleted();
        }
    }

    private void markCompleted() {
        this.completed = true;
        this.completedAt = Thread.currentThread().getStackTrace();
    }

    private void assertNotCompleted() {
        if (this.completed) {
            if (logger.isErrorEnabled()) {
                String currentStackTrace = StrictAsyncHandle.getStackTrace(new Throwable());
                Throwable prevTrace = new Throwable();
                prevTrace.setStackTrace(this.completedAt);
                String prevStrackTrace = StrictAsyncHandle.getStackTrace(prevTrace);
                String newLine = System.getProperty("line.separator");
                logger.error("Second attempt to complete the request" + newLine + currentStackTrace + newLine + "First attempt to complete the request" + newLine + prevStrackTrace);
            }
            throw new IllegalStateException("Operation is already completed");
        }
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

