/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.global_infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.global_infra;

public interface DhcpServerConfigs extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.global_infra.DhcpServerConfigsTypes {

    /**
     * Delete DHCP server configuration
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String dhcpServerConfigId);

    /**
     * Delete DHCP server configuration
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void delete(java.lang.String dhcpServerConfigId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete DHCP server configuration
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String dhcpServerConfigId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete DHCP server configuration
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String dhcpServerConfigId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read DHCP server configuration
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @return com.vmware.nsx_global_policy.model.DhcpServerConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.DhcpServerConfig get(java.lang.String dhcpServerConfigId);

    /**
     * Read DHCP server configuration
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.DhcpServerConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.DhcpServerConfig get(java.lang.String dhcpServerConfigId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read DHCP server configuration
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.DhcpServerConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String dhcpServerConfigId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.DhcpServerConfig> asyncCallback);

    /**
     * Read DHCP server configuration
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.DhcpServerConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String dhcpServerConfigId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.DhcpServerConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Paginated list of all DHCP server config instances
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_global_policy.model.DhcpServerConfigListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.DhcpServerConfigListResult list(java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Paginated list of all DHCP server config instances
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.DhcpServerConfigListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.DhcpServerConfigListResult list(java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Paginated list of all DHCP server config instances
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.DhcpServerConfigListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.DhcpServerConfigListResult> asyncCallback);

    /**
     * Paginated list of all DHCP server config instances
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.DhcpServerConfigListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includeMarkForDeleteObjects Include objects that are marked for deletion in results (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean includeMarkForDeleteObjects, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.DhcpServerConfigListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If DHCP server config with the dhcp-server-config-id is not already present,
     * create a new DHCP server config instance. If it already exists, update the DHCP
     * server config instance with specified attributes. Realized entities of this API
     * can be found using the path of Tier-0, Tier1, or Segment where this config is
     * applied on. Modification of edge_cluster_path in DhcpServerConfig will lose all
     * existing DHCP leases. If both the preferred_edge_paths in the DhcpServerConfig
     * are changed in a same PATCH API, e.g. change from [a,b] to [x,y], the current
     * DHCP server leases will be lost, which could cause network connectivity issues.
     * It is recommended to change only one member index in an update call, e.g. from
     * [a, b] to [a,y]. Clearing preferred_edge_paths will not reassign edge nodes from
     * the edge cluster. Instead, the previously-allocated edge nodes will be retained
     * to avoid loss of leases.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param dhcpServerConfig (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String dhcpServerConfigId, com.vmware.nsx_global_policy.model.DhcpServerConfig dhcpServerConfig);

    /**
     * If DHCP server config with the dhcp-server-config-id is not already present,
     * create a new DHCP server config instance. If it already exists, update the DHCP
     * server config instance with specified attributes. Realized entities of this API
     * can be found using the path of Tier-0, Tier1, or Segment where this config is
     * applied on. Modification of edge_cluster_path in DhcpServerConfig will lose all
     * existing DHCP leases. If both the preferred_edge_paths in the DhcpServerConfig
     * are changed in a same PATCH API, e.g. change from [a,b] to [x,y], the current
     * DHCP server leases will be lost, which could cause network connectivity issues.
     * It is recommended to change only one member index in an update call, e.g. from
     * [a, b] to [a,y]. Clearing preferred_edge_paths will not reassign edge nodes from
     * the edge cluster. Instead, the previously-allocated edge nodes will be retained
     * to avoid loss of leases.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param dhcpServerConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void patch(java.lang.String dhcpServerConfigId, com.vmware.nsx_global_policy.model.DhcpServerConfig dhcpServerConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If DHCP server config with the dhcp-server-config-id is not already present,
     * create a new DHCP server config instance. If it already exists, update the DHCP
     * server config instance with specified attributes. Realized entities of this API
     * can be found using the path of Tier-0, Tier1, or Segment where this config is
     * applied on. Modification of edge_cluster_path in DhcpServerConfig will lose all
     * existing DHCP leases. If both the preferred_edge_paths in the DhcpServerConfig
     * are changed in a same PATCH API, e.g. change from [a,b] to [x,y], the current
     * DHCP server leases will be lost, which could cause network connectivity issues.
     * It is recommended to change only one member index in an update call, e.g. from
     * [a, b] to [a,y]. Clearing preferred_edge_paths will not reassign edge nodes from
     * the edge cluster. Instead, the previously-allocated edge nodes will be retained
     * to avoid loss of leases.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param dhcpServerConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String dhcpServerConfigId, com.vmware.nsx_global_policy.model.DhcpServerConfig dhcpServerConfig, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If DHCP server config with the dhcp-server-config-id is not already present,
     * create a new DHCP server config instance. If it already exists, update the DHCP
     * server config instance with specified attributes. Realized entities of this API
     * can be found using the path of Tier-0, Tier1, or Segment where this config is
     * applied on. Modification of edge_cluster_path in DhcpServerConfig will lose all
     * existing DHCP leases. If both the preferred_edge_paths in the DhcpServerConfig
     * are changed in a same PATCH API, e.g. change from [a,b] to [x,y], the current
     * DHCP server leases will be lost, which could cause network connectivity issues.
     * It is recommended to change only one member index in an update call, e.g. from
     * [a, b] to [a,y]. Clearing preferred_edge_paths will not reassign edge nodes from
     * the edge cluster. Instead, the previously-allocated edge nodes will be retained
     * to avoid loss of leases.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param dhcpServerConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String dhcpServerConfigId, com.vmware.nsx_global_policy.model.DhcpServerConfig dhcpServerConfig, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If DHCP server config with the dhcp-server-config-id is not already present,
     * create a new DHCP server config instance. If it already exists, replace the DHCP
     * server config instance with this object. Realized entities of this API can be
     * found using the path of Tier-0, Tier1, or Segment where this config is applied
     * on. Modification of edge_cluster_path in DhcpServerConfig will lose all existing
     * DHCP leases. If both the preferred_edge_paths in the DhcpServerConfig are
     * changed in a same PUT API, e.g. change from [a,b] to [x,y], the current DHCP
     * server leases will be lost, which could cause network connectivity issues. It is
     * recommended to change only one member index in an update call, e.g. from [a, b]
     * to [a,y]. Clearing preferred_edge_paths will not reassign edge nodes from the
     * edge cluster. Instead, the previously-allocated edge nodes will be retained to
     * avoid loss of leases.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param dhcpServerConfig (required)
     * @return com.vmware.nsx_global_policy.model.DhcpServerConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.DhcpServerConfig update(java.lang.String dhcpServerConfigId, com.vmware.nsx_global_policy.model.DhcpServerConfig dhcpServerConfig);

    /**
     * If DHCP server config with the dhcp-server-config-id is not already present,
     * create a new DHCP server config instance. If it already exists, replace the DHCP
     * server config instance with this object. Realized entities of this API can be
     * found using the path of Tier-0, Tier1, or Segment where this config is applied
     * on. Modification of edge_cluster_path in DhcpServerConfig will lose all existing
     * DHCP leases. If both the preferred_edge_paths in the DhcpServerConfig are
     * changed in a same PUT API, e.g. change from [a,b] to [x,y], the current DHCP
     * server leases will be lost, which could cause network connectivity issues. It is
     * recommended to change only one member index in an update call, e.g. from [a, b]
     * to [a,y]. Clearing preferred_edge_paths will not reassign edge nodes from the
     * edge cluster. Instead, the previously-allocated edge nodes will be retained to
     * avoid loss of leases.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param dhcpServerConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.DhcpServerConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.DhcpServerConfig update(java.lang.String dhcpServerConfigId, com.vmware.nsx_global_policy.model.DhcpServerConfig dhcpServerConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If DHCP server config with the dhcp-server-config-id is not already present,
     * create a new DHCP server config instance. If it already exists, replace the DHCP
     * server config instance with this object. Realized entities of this API can be
     * found using the path of Tier-0, Tier1, or Segment where this config is applied
     * on. Modification of edge_cluster_path in DhcpServerConfig will lose all existing
     * DHCP leases. If both the preferred_edge_paths in the DhcpServerConfig are
     * changed in a same PUT API, e.g. change from [a,b] to [x,y], the current DHCP
     * server leases will be lost, which could cause network connectivity issues. It is
     * recommended to change only one member index in an update call, e.g. from [a, b]
     * to [a,y]. Clearing preferred_edge_paths will not reassign edge nodes from the
     * edge cluster. Instead, the previously-allocated edge nodes will be retained to
     * avoid loss of leases.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.DhcpServerConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param dhcpServerConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String dhcpServerConfigId, com.vmware.nsx_global_policy.model.DhcpServerConfig dhcpServerConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.DhcpServerConfig> asyncCallback);

    /**
     * If DHCP server config with the dhcp-server-config-id is not already present,
     * create a new DHCP server config instance. If it already exists, replace the DHCP
     * server config instance with this object. Realized entities of this API can be
     * found using the path of Tier-0, Tier1, or Segment where this config is applied
     * on. Modification of edge_cluster_path in DhcpServerConfig will lose all existing
     * DHCP leases. If both the preferred_edge_paths in the DhcpServerConfig are
     * changed in a same PUT API, e.g. change from [a,b] to [x,y], the current DHCP
     * server leases will be lost, which could cause network connectivity issues. It is
     * recommended to change only one member index in an update call, e.g. from [a, b]
     * to [a,y]. Clearing preferred_edge_paths will not reassign edge nodes from the
     * edge cluster. Instead, the previously-allocated edge nodes will be retained to
     * avoid loss of leases.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.DhcpServerConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param dhcpServerConfigId DHCP server config ID (required)
     * @param dhcpServerConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String dhcpServerConfigId, com.vmware.nsx_global_policy.model.DhcpServerConfig dhcpServerConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.DhcpServerConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
