/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.global_infra.realized_state.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.global_infra.realized_state;

public interface RealizedEntity extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.global_infra.realized_state.RealizedEntityTypes {

    /**
     * Refresh the status and statistics of all realized entities associated with given
     * intent path synchronously. The vmw-async: True HTTP header cannot be used with
     * this API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param intentPath String Path of the intent object (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void refresh(java.lang.String intentPath, java.lang.String enforcementPointPath);

    /**
     * Refresh the status and statistics of all realized entities associated with given
     * intent path synchronously. The vmw-async: True HTTP header cannot be used with
     * this API.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param intentPath String Path of the intent object (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public void refresh(java.lang.String intentPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Refresh the status and statistics of all realized entities associated with given
     * intent path synchronously. The vmw-async: True HTTP header cannot be used with
     * this API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param intentPath String Path of the intent object (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void refresh(java.lang.String intentPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Refresh the status and statistics of all realized entities associated with given
     * intent path synchronously. The vmw-async: True HTTP header cannot be used with
     * this API.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param intentPath String Path of the intent object (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void refresh(java.lang.String intentPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
