/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.global_infra.tier_0s.nat.nat_rules.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.global_infra.tier_0s.nat.nat_rules;

public interface Statistics extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.global_infra.tier_0s.nat.nat_rules.StatisticsTypes {

    /**
     * Get NAT Rule Statistics from Tier-0 denoted by Tier-0 ID, under NAT section
     * denoted by <nat-id>. Under tier-0 there will be 3 different NATs(sections).
     * (INTERNAL, USER and DEFAULT) For more details related to NAT section please
     * refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param action Action on statistics (optional)
     * @param containerClusterPath String Path of the Container Cluster entity (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @return com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsListResult list(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, java.lang.String action, java.lang.String containerClusterPath, java.lang.String enforcementPointPath);

    /**
     * Get NAT Rule Statistics from Tier-0 denoted by Tier-0 ID, under NAT section
     * denoted by <nat-id>. Under tier-0 there will be 3 different NATs(sections).
     * (INTERNAL, USER and DEFAULT) For more details related to NAT section please
     * refer to PolicyNAT schema.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param action Action on statistics (optional)
     * @param containerClusterPath String Path of the Container Cluster entity (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest  Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized  Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable  Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError  Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound  Not Found
     */
    public com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsListResult list(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, java.lang.String action, java.lang.String containerClusterPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get NAT Rule Statistics from Tier-0 denoted by Tier-0 ID, under NAT section
     * denoted by <nat-id>. Under tier-0 there will be 3 different NATs(sections).
     * (INTERNAL, USER and DEFAULT) For more details related to NAT section please
     * refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param action Action on statistics (optional)
     * @param containerClusterPath String Path of the Container Cluster entity (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, java.lang.String action, java.lang.String containerClusterPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsListResult> asyncCallback);

    /**
     * Get NAT Rule Statistics from Tier-0 denoted by Tier-0 ID, under NAT section
     * denoted by <nat-id>. Under tier-0 there will be 3 different NATs(sections).
     * (INTERNAL, USER and DEFAULT) For more details related to NAT section please
     * refer to PolicyNAT schema.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} -  Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} -  Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} -  Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} -  Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} -  Not Found<br>
     * </p>
     *
     * @param tier0Id Tier-0 ID (required)
     * @param natId NAT id (required)
     * @param natRuleId Rule ID (required)
     * @param action Action on statistics (optional)
     * @param containerClusterPath String Path of the Container Cluster entity (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String tier0Id, java.lang.String natId, java.lang.String natRuleId, java.lang.String action, java.lang.String containerClusterPath, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PolicyNatRuleStatisticsListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
