/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Consolidated Realized Status of an intent object across enforcement points.
 */
public final class ConsolidatedRealizedStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String PUBLISH_STATUS_UNAVAILABLE = "UNAVAILABLE";

    public static final java.lang.String PUBLISH_STATUS_UNREALIZED = "UNREALIZED";

    public static final java.lang.String PUBLISH_STATUS_REALIZED = "REALIZED";

    public static final java.lang.String PUBLISH_STATUS_ERROR = "ERROR";

    private java.lang.String intentPath;

    private com.vmware.nsx_global_policy.model.ConsolidatedStatus consolidatedStatus;

    private java.util.List<com.vmware.nsx_global_policy.model.ConsolidatedStatusPerEnforcementPoint> consolidatedStatusPerEnforcementPoint;

    private java.lang.String intentVersion;

    private java.lang.String publishStatus;

    private java.lang.Long publishTime;

    private java.lang.String siteUuid;

    private java.lang.Long timeTakenForRealization;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ConsolidatedRealizedStatus() {
    }

    protected ConsolidatedRealizedStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Intent path of object, forward slashes must be escaped using %2F.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIntentPath() {
        return this.intentPath;
    }

    /**
     * Intent path of object, forward slashes must be escaped using %2F.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param intentPath New value for the property.
     */
    public void setIntentPath(java.lang.String intentPath) {
        this.intentPath = intentPath;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.ConsolidatedStatus getConsolidatedStatus() {
        return this.consolidatedStatus;
    }

    /**
     *
     *
     * @param consolidatedStatus New value for the property.
     */
    public void setConsolidatedStatus(com.vmware.nsx_global_policy.model.ConsolidatedStatus consolidatedStatus) {
        this.consolidatedStatus = consolidatedStatus;
    }

    /**
     * List of Consolidated Realized Status per enforcement point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ConsolidatedStatusPerEnforcementPoint> getConsolidatedStatusPerEnforcementPoint() {
        return this.consolidatedStatusPerEnforcementPoint;
    }

    /**
     * List of Consolidated Realized Status per enforcement point.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param consolidatedStatusPerEnforcementPoint New value for the property.
     */
    public void setConsolidatedStatusPerEnforcementPoint(java.util.List<com.vmware.nsx_global_policy.model.ConsolidatedStatusPerEnforcementPoint> consolidatedStatusPerEnforcementPoint) {
        this.consolidatedStatusPerEnforcementPoint = consolidatedStatusPerEnforcementPoint;
    }

    /**
     * Represent highest intent version across all realized objects
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIntentVersion() {
        return this.intentVersion;
    }

    /**
     * Represent highest intent version across all realized objects
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param intentVersion New value for the property.
     */
    public void setIntentVersion(java.lang.String intentVersion) {
        this.intentVersion = intentVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_UNAVAILABLE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_UNREALIZED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_REALIZED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_ERROR}</li>
     * </ul> Aggregated Realization state of this object
     *
     * @return The current value of the property.
     */
    public java.lang.String getPublishStatus() {
        return this.publishStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_UNAVAILABLE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_UNREALIZED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_REALIZED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_ERROR}</li>
     * </ul> Aggregated Realization state of this object
     *
     * @param publishStatus New value for the property.
     */
    public void setPublishStatus(java.lang.String publishStatus) {
        this.publishStatus = publishStatus;
    }

    /**
     * This is the time when our system detects that data has been pushed to the
     * transport nodes. This is based on a poll mechanism and hence this is not the
     * accurate time when the intent was published at the data path. The value of -1
     * indicates that either the publishing is still in progress or the runtime status
     * is UNKNOWN and hence not available. The Runtime status can be UNKNOWN if one or
     * more hosts are down and the rules could not be sent to those hosts. When the
     * host comes up, the runtime status will change to SUCCESS but the publish_time
     * will show the value of the last realization time. Any new configuration change
     * after this will start reflecting the proper value for publish_time format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPublishTime() {
        return this.publishTime;
    }

    /**
     * This is the time when our system detects that data has been pushed to the
     * transport nodes. This is based on a poll mechanism and hence this is not the
     * accurate time when the intent was published at the data path. The value of -1
     * indicates that either the publishing is still in progress or the runtime status
     * is UNKNOWN and hence not available. The Runtime status can be UNKNOWN if one or
     * more hosts are down and the rules could not be sent to those hosts. When the
     * host comes up, the runtime status will change to SUCCESS but the publish_time
     * will show the value of the last realization time. Any new configuration change
     * after this will start reflecting the proper value for publish_time format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param publishTime New value for the property.
     */
    public void setPublishTime(java.lang.Long publishTime) {
        this.publishTime = publishTime;
    }

    /**
     * Site UUID supplied for realized site.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSiteUuid() {
        return this.siteUuid;
    }

    /**
     * Site UUID supplied for realized site.
     *
     * @param siteUuid New value for the property.
     */
    public void setSiteUuid(java.lang.String siteUuid) {
        this.siteUuid = siteUuid;
    }

    /**
     * This is an approximate time taken for the realization of the intent to the data
     * path. The actual time taken could be lesser than what is reported here. The
     * value of -1 indicates that either the publishing is still in progress or the
     * runtime status is UNKNOWN and hence not available. The Runtime status can be
     * UNKNOWN if one or more hosts are down and the rules could not be sent to those
     * hosts. When the host comes up, the runtime status will change to SUCCESS but the
     * time taken for realization will show the value of the last realization time. Any
     * new configuration change after this will start reflecting the proper value for
     * time_taken_for_realization. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimeTakenForRealization() {
        return this.timeTakenForRealization;
    }

    /**
     * This is an approximate time taken for the realization of the intent to the data
     * path. The actual time taken could be lesser than what is reported here. The
     * value of -1 indicates that either the publishing is still in progress or the
     * runtime status is UNKNOWN and hence not available. The Runtime status can be
     * UNKNOWN if one or more hosts are down and the rules could not be sent to those
     * hosts. When the host comes up, the runtime status will change to SUCCESS but the
     * time taken for realization will show the value of the last realization time. Any
     * new configuration change after this will start reflecting the proper value for
     * time_taken_for_realization. format: int64
     *
     * @param timeTakenForRealization New value for the property.
     */
    public void setTimeTakenForRealization(java.lang.Long timeTakenForRealization) {
        this.timeTakenForRealization = timeTakenForRealization;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedRealizedStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("intent_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.intentPath, this._getType().getField("intent_path")));
        structValue.setField("consolidated_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.consolidatedStatus, this._getType().getField("consolidated_status")));
        structValue.setField("consolidated_status_per_enforcement_point",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.consolidatedStatusPerEnforcementPoint, this._getType().getField("consolidated_status_per_enforcement_point")));
        structValue.setField("intent_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.intentVersion, this._getType().getField("intent_version")));
        structValue.setField("publish_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.publishStatus, this._getType().getField("publish_status")));
        structValue.setField("publish_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.publishTime, this._getType().getField("publish_time")));
        structValue.setField("site_uuid",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.siteUuid, this._getType().getField("site_uuid")));
        structValue.setField("time_taken_for_realization",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timeTakenForRealization, this._getType().getField("time_taken_for_realization")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedRealizedStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedRealizedStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ConsolidatedRealizedStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ConsolidatedRealizedStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ConsolidatedRealizedStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ConsolidatedRealizedStatus(structValue);
    }

    /**
     * Builder class for {@link ConsolidatedRealizedStatus}.
     */
    public static final class Builder {
        private java.lang.String intentPath;
        private com.vmware.nsx_global_policy.model.ConsolidatedStatus consolidatedStatus;
        private java.util.List<com.vmware.nsx_global_policy.model.ConsolidatedStatusPerEnforcementPoint> consolidatedStatusPerEnforcementPoint;
        private java.lang.String intentVersion;
        private java.lang.String publishStatus;
        private java.lang.Long publishTime;
        private java.lang.String siteUuid;
        private java.lang.Long timeTakenForRealization;

        /**
         * Constructor with parameters for the required properties of
         * {@link ConsolidatedRealizedStatus}.
         */
        public Builder() {
        }

        /**
         * Intent path of object, forward slashes must be escaped using %2F.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param intentPath New value for the property.
         */
        public Builder setIntentPath(java.lang.String intentPath) {
            this.intentPath = intentPath;
            return this;
        }

        /**
         *
         *
         * @param consolidatedStatus New value for the property.
         */
        public Builder setConsolidatedStatus(com.vmware.nsx_global_policy.model.ConsolidatedStatus consolidatedStatus) {
            this.consolidatedStatus = consolidatedStatus;
            return this;
        }

        /**
         * List of Consolidated Realized Status per enforcement point.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param consolidatedStatusPerEnforcementPoint New value for the property.
         */
        public Builder setConsolidatedStatusPerEnforcementPoint(java.util.List<com.vmware.nsx_global_policy.model.ConsolidatedStatusPerEnforcementPoint> consolidatedStatusPerEnforcementPoint) {
            this.consolidatedStatusPerEnforcementPoint = consolidatedStatusPerEnforcementPoint;
            return this;
        }

        /**
         * Represent highest intent version across all realized objects
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param intentVersion New value for the property.
         */
        public Builder setIntentVersion(java.lang.String intentVersion) {
            this.intentVersion = intentVersion;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_UNAVAILABLE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_UNREALIZED}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_REALIZED}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus#PUBLISH_STATUS_ERROR}</li>
         * </ul> Aggregated Realization state of this object
         *
         * @param publishStatus New value for the property.
         */
        public Builder setPublishStatus(java.lang.String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        /**
         * This is the time when our system detects that data has been pushed to the
         * transport nodes. This is based on a poll mechanism and hence this is not the
         * accurate time when the intent was published at the data path. The value of -1
         * indicates that either the publishing is still in progress or the runtime status
         * is UNKNOWN and hence not available. The Runtime status can be UNKNOWN if one or
         * more hosts are down and the rules could not be sent to those hosts. When the
         * host comes up, the runtime status will change to SUCCESS but the publish_time
         * will show the value of the last realization time. Any new configuration change
         * after this will start reflecting the proper value for publish_time format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param publishTime New value for the property.
         */
        public Builder setPublishTime(java.lang.Long publishTime) {
            this.publishTime = publishTime;
            return this;
        }

        /**
         * Site UUID supplied for realized site.
         *
         * @param siteUuid New value for the property.
         */
        public Builder setSiteUuid(java.lang.String siteUuid) {
            this.siteUuid = siteUuid;
            return this;
        }

        /**
         * This is an approximate time taken for the realization of the intent to the data
         * path. The actual time taken could be lesser than what is reported here. The
         * value of -1 indicates that either the publishing is still in progress or the
         * runtime status is UNKNOWN and hence not available. The Runtime status can be
         * UNKNOWN if one or more hosts are down and the rules could not be sent to those
         * hosts. When the host comes up, the runtime status will change to SUCCESS but the
         * time taken for realization will show the value of the last realization time. Any
         * new configuration change after this will start reflecting the proper value for
         * time_taken_for_realization. format: int64
         *
         * @param timeTakenForRealization New value for the property.
         */
        public Builder setTimeTakenForRealization(java.lang.Long timeTakenForRealization) {
            this.timeTakenForRealization = timeTakenForRealization;
            return this;
        }

        public ConsolidatedRealizedStatus build() {
            ConsolidatedRealizedStatus result = new ConsolidatedRealizedStatus();
            result.setIntentPath(this.intentPath);
            result.setConsolidatedStatus(this.consolidatedStatus);
            result.setConsolidatedStatusPerEnforcementPoint(this.consolidatedStatusPerEnforcementPoint);
            result.setIntentVersion(this.intentVersion);
            result.setPublishStatus(this.publishStatus);
            result.setPublishTime(this.publishTime);
            result.setSiteUuid(this.siteUuid);
            result.setTimeTakenForRealization(this.timeTakenForRealization);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("intent_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("intent_path",
                                                                                "intentPath",
                                                                                "getIntentPath",
                                                                                "setIntentPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("consolidated_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedStatus; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("consolidated_status",
                                                                                "consolidatedStatus",
                                                                                "getConsolidatedStatus",
                                                                                "setConsolidatedStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("consolidated_status_per_enforcement_point", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.consolidatedStatusPerEnforcementPoint; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("consolidated_status_per_enforcement_point",
                                                                                "consolidatedStatusPerEnforcementPoint",
                                                                                "getConsolidatedStatusPerEnforcementPoint",
                                                                                "setConsolidatedStatusPerEnforcementPoint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("intent_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("intent_version",
                                                                                "intentVersion",
                                                                                "getIntentVersion",
                                                                                "setIntentVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("publish_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("publish_status",
                                                                                "publishStatus",
                                                                                "getPublishStatus",
                                                                                "setPublishStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("publish_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("publish_time",
                                                                                "publishTime",
                                                                                "getPublishTime",
                                                                                "setPublishTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_uuid", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_uuid",
                                                                                "siteUuid",
                                                                                "getSiteUuid",
                                                                                "setSiteUuid");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("time_taken_for_realization", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("time_taken_for_realization",
                                                                                "timeTakenForRealization",
                                                                                "getTimeTakenForRealization",
                                                                                "setTimeTakenForRealization");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.consolidated_realized_status",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.ConsolidatedRealizedStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

