/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Represents configuration for custom widget. For this widget the data source is
 * not applicable. It defines ui identifer to identify UI component and render it
 * on dashboard view. This configuration can only be used for system owned widgets.
 */
public final class CustomWidgetConfiguration implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "CustomWidgetConfiguration";

    private java.lang.String uiComponentIdentifier;

    private java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx_global_policy.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private final java.lang.String resourceType = "CustomWidgetConfiguration";

    private java.util.List<com.vmware.nsx_global_policy.model.Tag> tags;

    private java.lang.String condition;

    private java.util.List<com.vmware.nsx_global_policy.model.Datasource> datasources;

    private java.util.List<com.vmware.nsx_global_policy.model.DefaultFilterValue> defaultFilterValue;

    private java.lang.String drilldownId;

    private com.vmware.nsx_global_policy.model.FeatureSet featureSet;

    private java.lang.String filter;

    private java.lang.Boolean filterValueRequired;

    private java.util.List<java.lang.String> filters;

    private com.vmware.nsx_global_policy.model.Footer footer;

    private java.util.List<com.vmware.nsx_global_policy.model.Icon> icons;

    private java.lang.Boolean isDrilldown;

    private com.vmware.nsx_global_policy.model.Legend legend;

    private java.util.List<com.vmware.nsx_global_policy.model.WidgetPlotConfiguration> plotConfigs;

    private java.lang.Long rowspan;

    private java.lang.Boolean shared;

    private java.lang.Boolean showHeader;

    private java.lang.Long span;

    private java.lang.Long weight;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CustomWidgetConfiguration() {
    }

    protected CustomWidgetConfiguration(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * User defined component selector to be rendered inside view/container.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUiComponentIdentifier() {
        return this.uiComponentIdentifier;
    }

    /**
     * User defined component selector to be rendered inside view/container.
     *
     * @param uiComponentIdentifier New value for the property.
     */
    public void setUiComponentIdentifier(java.lang.String uiComponentIdentifier) {
        this.uiComponentIdentifier = uiComponentIdentifier;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx_global_policy.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Title of the widget. If display_name is omitted, the widget will be shown
     * without a title.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Title of the widget. If display_name is omitted, the widget will be shown
     * without a title.
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_LABELVALUECONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_DONUTCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_MULTIWIDGETCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_CONTAINERCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_STATSCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_GRIDCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_GRAPHCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_CUSTOMFILTERWIDGETCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_TIMERANGEDROPDOWNFILTERWIDGETCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_SPACERWIDGETCONFIGURATION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.WidgetConfiguration#RESOURCE_TYPE_LEGENDWIDGETCONFIGURATION}</li>
     * </ul> Supported visualization types are LabelValueConfiguration,
     * DonutConfiguration, GridConfiguration, StatsConfiguration,
     * MultiWidgetConfiguration, GraphConfiguration, ContainerConfiguration,
     * CustomWidgetConfiguration, CustomFilterWidgetConfiguration,
     * TimeRangeDropdownFilterWidgetConfiguration, SpacerWidgetConfiguration,
     * LegendWidgetConfiguration and DropdownFilterWidgetConfiguration.
     * The value of this property is automatically populated to {@code "CustomWidgetConfiguration"}.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx_global_policy.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * If the condition is met then the widget will be displayed to UI. If no condition
     * is provided, then the widget will be displayed unconditionally.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCondition() {
        return this.condition;
    }

    /**
     * If the condition is met then the widget will be displayed to UI. If no condition
     * is provided, then the widget will be displayed unconditionally.
     *
     * @param condition New value for the property.
     */
    public void setCondition(java.lang.String condition) {
        this.condition = condition;
    }

    /**
     * The 'datasources' represent the sources from which data will be fetched.
     * Currently, only NSX-API is supported as a 'default' datasource. An example of
     * specifying 'default' datasource along with the urls to fetch data from is given
     * at 'example_request' section of 'CreateWidgetConfiguration' API.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.Datasource> getDatasources() {
        return this.datasources;
    }

    /**
     * The 'datasources' represent the sources from which data will be fetched.
     * Currently, only NSX-API is supported as a 'default' datasource. An example of
     * specifying 'default' datasource along with the urls to fetch data from is given
     * at 'example_request' section of 'CreateWidgetConfiguration' API.
     *
     * @param datasources New value for the property.
     */
    public void setDatasources(java.util.List<com.vmware.nsx_global_policy.model.Datasource> datasources) {
        this.datasources = datasources;
    }

    /**
     * Default filter values to be passed to datasources. This will be used when the
     * report is requested without filter values.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.DefaultFilterValue> getDefaultFilterValue() {
        return this.defaultFilterValue;
    }

    /**
     * Default filter values to be passed to datasources. This will be used when the
     * report is requested without filter values.
     *
     * @param defaultFilterValue New value for the property.
     */
    public void setDefaultFilterValue(java.util.List<com.vmware.nsx_global_policy.model.DefaultFilterValue> defaultFilterValue) {
        this.defaultFilterValue = defaultFilterValue;
    }

    /**
     * Id of drilldown widget, if any. Id should be a valid id of an existing widget. A
     * widget is considered as drilldown widget when it is associated with any other
     * widget and provides more detailed information about any data item from the
     * parent widget.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDrilldownId() {
        return this.drilldownId;
    }

    /**
     * Id of drilldown widget, if any. Id should be a valid id of an existing widget. A
     * widget is considered as drilldown widget when it is associated with any other
     * widget and provides more detailed information about any data item from the
     * parent widget.
     *
     * @param drilldownId New value for the property.
     */
    public void setDrilldownId(java.lang.String drilldownId) {
        this.drilldownId = drilldownId;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    /**
     *
     *
     * @param featureSet New value for the property.
     */
    public void setFeatureSet(com.vmware.nsx_global_policy.model.FeatureSet featureSet) {
        this.featureSet = featureSet;
    }

    /**
     * Id of filter widget for subscription, if any. Id should be a valid id of an
     * existing filter widget. Filter widget should be from the same view. Datasource
     * URLs should have placeholder values equal to filter alias to accept the filter
     * value on filter change. This field is deprecated instead use 'filters' property.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getFilter() {
        return this.filter;
    }

    /**
     * Id of filter widget for subscription, if any. Id should be a valid id of an
     * existing filter widget. Filter widget should be from the same view. Datasource
     * URLs should have placeholder values equal to filter alias to accept the filter
     * value on filter change. This field is deprecated instead use 'filters' property.
     *
     * @param filter New value for the property.
     */
    @Deprecated
    public void setFilter(java.lang.String filter) {
        this.filter = filter;
    }

    /**
     * Flag to indicate that widget will continue to work without filter value. If this
     * flag is set to false then default_filter_value is manadatory.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getFilterValueRequired() {
        return this.filterValueRequired;
    }

    /**
     * Flag to indicate that widget will continue to work without filter value. If this
     * flag is set to false then default_filter_value is manadatory.
     *
     * @param filterValueRequired New value for the property.
     */
    public void setFilterValueRequired(java.lang.Boolean filterValueRequired) {
        this.filterValueRequired = filterValueRequired;
    }

    /**
     * A List of filter applied to this widget configuration. This will be used to
     * identify the filters applied to this widget.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getFilters() {
        return this.filters;
    }

    /**
     * A List of filter applied to this widget configuration. This will be used to
     * identify the filters applied to this widget.
     *
     * @param filters New value for the property.
     */
    public void setFilters(java.util.List<java.lang.String> filters) {
        this.filters = filters;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.Footer getFooter() {
        return this.footer;
    }

    /**
     *
     *
     * @param footer New value for the property.
     */
    public void setFooter(com.vmware.nsx_global_policy.model.Footer footer) {
        this.footer = footer;
    }

    /**
     * Icons to be applied at dashboard for widgets and UI elements.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.Icon> getIcons() {
        return this.icons;
    }

    /**
     * Icons to be applied at dashboard for widgets and UI elements.
     *
     * @param icons New value for the property.
     */
    public void setIcons(java.util.List<com.vmware.nsx_global_policy.model.Icon> icons) {
        this.icons = icons;
    }

    /**
     * Set to true if this widget should be used as a drilldown.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsDrilldown() {
        return this.isDrilldown;
    }

    /**
     * Set to true if this widget should be used as a drilldown.
     *
     * @param isDrilldown New value for the property.
     */
    public void setIsDrilldown(java.lang.Boolean isDrilldown) {
        this.isDrilldown = isDrilldown;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx_global_policy.model.Legend getLegend() {
        return this.legend;
    }

    /**
     *
     *
     * @param legend New value for the property.
     */
    public void setLegend(com.vmware.nsx_global_policy.model.Legend legend) {
        this.legend = legend;
    }

    /**
     * List of plotting configuration for a given widget. Widget plotting
     * configurations which are common across all the widgets types should be define
     * here.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.WidgetPlotConfiguration> getPlotConfigs() {
        return this.plotConfigs;
    }

    /**
     * List of plotting configuration for a given widget. Widget plotting
     * configurations which are common across all the widgets types should be define
     * here.
     *
     * @param plotConfigs New value for the property.
     */
    public void setPlotConfigs(java.util.List<com.vmware.nsx_global_policy.model.WidgetPlotConfiguration> plotConfigs) {
        this.plotConfigs = plotConfigs;
    }

    /**
     * Represents the vertical span of the widget / container. 1 Row span is equal to
     * 20px. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRowspan() {
        return this.rowspan;
    }

    /**
     * Represents the vertical span of the widget / container. 1 Row span is equal to
     * 20px. format: int32
     *
     * @param rowspan New value for the property.
     */
    public void setRowspan(java.lang.Long rowspan) {
        this.rowspan = rowspan;
    }

    /**
     * Please use the property 'shared' of View instead of this. The widgets of a
     * shared view are visible to other users.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Boolean getShared() {
        return this.shared;
    }

    /**
     * Please use the property 'shared' of View instead of this. The widgets of a
     * shared view are visible to other users.
     *
     * @param shared New value for the property.
     */
    @Deprecated
    public void setShared(java.lang.Boolean shared) {
        this.shared = shared;
    }

    /**
     * If the value of this field is set to true then card header will be displayed
     * otherwise only card will be displayed without header.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getShowHeader() {
        return this.showHeader;
    }

    /**
     * If the value of this field is set to true then card header will be displayed
     * otherwise only card will be displayed without header.
     *
     * @param showHeader New value for the property.
     */
    public void setShowHeader(java.lang.Boolean showHeader) {
        this.showHeader = showHeader;
    }

    /**
     * Represents the horizontal span of the widget / container. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSpan() {
        return this.span;
    }

    /**
     * Represents the horizontal span of the widget / container. format: int32
     *
     * @param span New value for the property.
     */
    public void setSpan(java.lang.Long span) {
        this.span = span;
    }

    /**
     * Specify relavite weight in WidgetItem for placement in a view. Please see
     * WidgetItem for details. format: int32
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getWeight() {
        return this.weight;
    }

    /**
     * Specify relavite weight in WidgetItem for placement in a view. Please see
     * WidgetItem for details. format: int32
     *
     * @param weight New value for the property.
     */
    @Deprecated
    public void setWeight(java.lang.Long weight) {
        this.weight = weight;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.customWidgetConfiguration;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("ui_component_identifier",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.uiComponentIdentifier, this._getType().getField("ui_component_identifier")));
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("condition",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.condition, this._getType().getField("condition")));
        structValue.setField("datasources",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.datasources, this._getType().getField("datasources")));
        structValue.setField("default_filter_value",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultFilterValue, this._getType().getField("default_filter_value")));
        structValue.setField("drilldown_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.drilldownId, this._getType().getField("drilldown_id")));
        structValue.setField("feature_set",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.featureSet, this._getType().getField("feature_set")));
        structValue.setField("filter",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.filter, this._getType().getField("filter")));
        structValue.setField("filter_value_required",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.filterValueRequired, this._getType().getField("filter_value_required")));
        structValue.setField("filters",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.filters, this._getType().getField("filters")));
        structValue.setField("footer",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.footer, this._getType().getField("footer")));
        structValue.setField("icons",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.icons, this._getType().getField("icons")));
        structValue.setField("is_drilldown",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isDrilldown, this._getType().getField("is_drilldown")));
        structValue.setField("legend",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.legend, this._getType().getField("legend")));
        structValue.setField("plot_configs",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.plotConfigs, this._getType().getField("plot_configs")));
        structValue.setField("rowspan",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rowspan, this._getType().getField("rowspan")));
        structValue.setField("shared",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.shared, this._getType().getField("shared")));
        structValue.setField("show_header",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.showHeader, this._getType().getField("show_header")));
        structValue.setField("span",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.span, this._getType().getField("span")));
        structValue.setField("weight",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.weight, this._getType().getField("weight")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.customWidgetConfiguration;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.customWidgetConfiguration.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CustomWidgetConfiguration _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CustomWidgetConfiguration(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CustomWidgetConfiguration _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CustomWidgetConfiguration(structValue);
    }

    /**
     * Builder class for {@link CustomWidgetConfiguration}.
     */
    public static final class Builder {
        private java.lang.String uiComponentIdentifier;
        private java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx_global_policy.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.util.List<com.vmware.nsx_global_policy.model.Tag> tags;
        private java.lang.String condition;
        private java.util.List<com.vmware.nsx_global_policy.model.Datasource> datasources;
        private java.util.List<com.vmware.nsx_global_policy.model.DefaultFilterValue> defaultFilterValue;
        private java.lang.String drilldownId;
        private com.vmware.nsx_global_policy.model.FeatureSet featureSet;
        private java.lang.String filter;
        private java.lang.Boolean filterValueRequired;
        private java.util.List<java.lang.String> filters;
        private com.vmware.nsx_global_policy.model.Footer footer;
        private java.util.List<com.vmware.nsx_global_policy.model.Icon> icons;
        private java.lang.Boolean isDrilldown;
        private com.vmware.nsx_global_policy.model.Legend legend;
        private java.util.List<com.vmware.nsx_global_policy.model.WidgetPlotConfiguration> plotConfigs;
        private java.lang.Long rowspan;
        private java.lang.Boolean shared;
        private java.lang.Boolean showHeader;
        private java.lang.Long span;
        private java.lang.Long weight;

        /**
         * Constructor with parameters for the required properties of
         * {@link CustomWidgetConfiguration}.
         */
        public Builder() {
        }

        /**
         * User defined component selector to be rendered inside view/container.
         *
         * @param uiComponentIdentifier New value for the property.
         */
        public Builder setUiComponentIdentifier(java.lang.String uiComponentIdentifier) {
            this.uiComponentIdentifier = uiComponentIdentifier;
            return this;
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx_global_policy.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx_global_policy.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Title of the widget. If display_name is omitted, the widget will be shown
         * without a title.
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx_global_policy.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * If the condition is met then the widget will be displayed to UI. If no condition
         * is provided, then the widget will be displayed unconditionally.
         *
         * @param condition New value for the property.
         */
        public Builder setCondition(java.lang.String condition) {
            this.condition = condition;
            return this;
        }

        /**
         * The 'datasources' represent the sources from which data will be fetched.
         * Currently, only NSX-API is supported as a 'default' datasource. An example of
         * specifying 'default' datasource along with the urls to fetch data from is given
         * at 'example_request' section of 'CreateWidgetConfiguration' API.
         *
         * @param datasources New value for the property.
         */
        public Builder setDatasources(java.util.List<com.vmware.nsx_global_policy.model.Datasource> datasources) {
            this.datasources = datasources;
            return this;
        }

        /**
         * Default filter values to be passed to datasources. This will be used when the
         * report is requested without filter values.
         *
         * @param defaultFilterValue New value for the property.
         */
        public Builder setDefaultFilterValue(java.util.List<com.vmware.nsx_global_policy.model.DefaultFilterValue> defaultFilterValue) {
            this.defaultFilterValue = defaultFilterValue;
            return this;
        }

        /**
         * Id of drilldown widget, if any. Id should be a valid id of an existing widget. A
         * widget is considered as drilldown widget when it is associated with any other
         * widget and provides more detailed information about any data item from the
         * parent widget.
         *
         * @param drilldownId New value for the property.
         */
        public Builder setDrilldownId(java.lang.String drilldownId) {
            this.drilldownId = drilldownId;
            return this;
        }

        /**
         *
         *
         * @param featureSet New value for the property.
         */
        public Builder setFeatureSet(com.vmware.nsx_global_policy.model.FeatureSet featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        /**
         * Id of filter widget for subscription, if any. Id should be a valid id of an
         * existing filter widget. Filter widget should be from the same view. Datasource
         * URLs should have placeholder values equal to filter alias to accept the filter
         * value on filter change. This field is deprecated instead use 'filters' property.
         *
         * @param filter New value for the property.
         */
        public Builder setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
        }

        /**
         * Flag to indicate that widget will continue to work without filter value. If this
         * flag is set to false then default_filter_value is manadatory.
         *
         * @param filterValueRequired New value for the property.
         */
        public Builder setFilterValueRequired(java.lang.Boolean filterValueRequired) {
            this.filterValueRequired = filterValueRequired;
            return this;
        }

        /**
         * A List of filter applied to this widget configuration. This will be used to
         * identify the filters applied to this widget.
         *
         * @param filters New value for the property.
         */
        public Builder setFilters(java.util.List<java.lang.String> filters) {
            this.filters = filters;
            return this;
        }

        /**
         *
         *
         * @param footer New value for the property.
         */
        public Builder setFooter(com.vmware.nsx_global_policy.model.Footer footer) {
            this.footer = footer;
            return this;
        }

        /**
         * Icons to be applied at dashboard for widgets and UI elements.
         *
         * @param icons New value for the property.
         */
        public Builder setIcons(java.util.List<com.vmware.nsx_global_policy.model.Icon> icons) {
            this.icons = icons;
            return this;
        }

        /**
         * Set to true if this widget should be used as a drilldown.
         *
         * @param isDrilldown New value for the property.
         */
        public Builder setIsDrilldown(java.lang.Boolean isDrilldown) {
            this.isDrilldown = isDrilldown;
            return this;
        }

        /**
         *
         *
         * @param legend New value for the property.
         */
        public Builder setLegend(com.vmware.nsx_global_policy.model.Legend legend) {
            this.legend = legend;
            return this;
        }

        /**
         * List of plotting configuration for a given widget. Widget plotting
         * configurations which are common across all the widgets types should be define
         * here.
         *
         * @param plotConfigs New value for the property.
         */
        public Builder setPlotConfigs(java.util.List<com.vmware.nsx_global_policy.model.WidgetPlotConfiguration> plotConfigs) {
            this.plotConfigs = plotConfigs;
            return this;
        }

        /**
         * Represents the vertical span of the widget / container. 1 Row span is equal to
         * 20px. format: int32
         *
         * @param rowspan New value for the property.
         */
        public Builder setRowspan(java.lang.Long rowspan) {
            this.rowspan = rowspan;
            return this;
        }

        /**
         * Please use the property 'shared' of View instead of this. The widgets of a
         * shared view are visible to other users.
         *
         * @param shared New value for the property.
         */
        public Builder setShared(java.lang.Boolean shared) {
            this.shared = shared;
            return this;
        }

        /**
         * If the value of this field is set to true then card header will be displayed
         * otherwise only card will be displayed without header.
         *
         * @param showHeader New value for the property.
         */
        public Builder setShowHeader(java.lang.Boolean showHeader) {
            this.showHeader = showHeader;
            return this;
        }

        /**
         * Represents the horizontal span of the widget / container. format: int32
         *
         * @param span New value for the property.
         */
        public Builder setSpan(java.lang.Long span) {
            this.span = span;
            return this;
        }

        /**
         * Specify relavite weight in WidgetItem for placement in a view. Please see
         * WidgetItem for details. format: int32
         *
         * @param weight New value for the property.
         */
        public Builder setWeight(java.lang.Long weight) {
            this.weight = weight;
            return this;
        }

        public CustomWidgetConfiguration build() {
            CustomWidgetConfiguration result = new CustomWidgetConfiguration();
            result.setUiComponentIdentifier(this.uiComponentIdentifier);
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setTags(this.tags);
            result.setCondition(this.condition);
            result.setDatasources(this.datasources);
            result.setDefaultFilterValue(this.defaultFilterValue);
            result.setDrilldownId(this.drilldownId);
            result.setFeatureSet(this.featureSet);
            result.setFilter(this.filter);
            result.setFilterValueRequired(this.filterValueRequired);
            result.setFilters(this.filters);
            result.setFooter(this.footer);
            result.setIcons(this.icons);
            result.setIsDrilldown(this.isDrilldown);
            result.setLegend(this.legend);
            result.setPlotConfigs(this.plotConfigs);
            result.setRowspan(this.rowspan);
            result.setShared(this.shared);
            result.setShowHeader(this.showHeader);
            result.setSpan(this.span);
            result.setWeight(this.weight);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("ui_component_identifier", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ui_component_identifier",
                                                                                "uiComponentIdentifier",
                                                                                "getUiComponentIdentifier",
                                                                                "setUiComponentIdentifier");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("condition", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("condition",
                                                                                "condition",
                                                                                "getCondition",
                                                                                "setCondition");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("datasources", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.datasource; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("datasources",
                                                                                "datasources",
                                                                                "getDatasources",
                                                                                "setDatasources");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_filter_value", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.defaultFilterValue; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_filter_value",
                                                                                "defaultFilterValue",
                                                                                "getDefaultFilterValue",
                                                                                "setDefaultFilterValue");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("drilldown_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("drilldown_id",
                                                                                "drilldownId",
                                                                                "getDrilldownId",
                                                                                "setDrilldownId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("feature_set", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.featureSet; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("feature_set",
                                                                                "featureSet",
                                                                                "getFeatureSet",
                                                                                "setFeatureSet");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("filter", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("filter",
                                                                                "filter",
                                                                                "getFilter",
                                                                                "setFilter");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("filter_value_required", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("filter_value_required",
                                                                                "filterValueRequired",
                                                                                "getFilterValueRequired",
                                                                                "setFilterValueRequired");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("filters", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("filters",
                                                                                "filters",
                                                                                "getFilters",
                                                                                "setFilters");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("footer", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.footer; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("footer",
                                                                                "footer",
                                                                                "getFooter",
                                                                                "setFooter");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("icons", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.icon; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("icons",
                                                                                "icons",
                                                                                "getIcons",
                                                                                "setIcons");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_drilldown", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_drilldown",
                                                                                "isDrilldown",
                                                                                "getIsDrilldown",
                                                                                "setIsDrilldown");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("legend", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.legend; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("legend",
                                                                                "legend",
                                                                                "getLegend",
                                                                                "setLegend");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("plot_configs", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.widgetPlotConfiguration; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("plot_configs",
                                                                                "plotConfigs",
                                                                                "getPlotConfigs",
                                                                                "setPlotConfigs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rowspan", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rowspan",
                                                                                "rowspan",
                                                                                "getRowspan",
                                                                                "setRowspan");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("shared", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("shared",
                                                                                "shared",
                                                                                "getShared",
                                                                                "setShared");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("show_header", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("show_header",
                                                                                "showHeader",
                                                                                "getShowHeader",
                                                                                "setShowHeader");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("span", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("span",
                                                                                "span",
                                                                                "getSpan",
                                                                                "setSpan");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("weight", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("weight",
                                                                                "weight",
                                                                                "getWeight",
                                                                                "setWeight");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.custom_widget_configuration",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.CustomWidgetConfiguration.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "CustomWidgetConfiguration");
    }
}

