/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Represents the switchover operational state of Global Manager. Offers
 * information about the current switchover operation including status from each
 * Global Manager node and the errors if any.
 */
public final class GmOperationalState implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CONSOLIDATED_PROGRESS_IN_PROGRESS = "IN_PROGRESS";

    public static final java.lang.String CONSOLIDATED_PROGRESS_COMPLETED = "COMPLETED";

    public static final java.lang.String CONSOLIDATED_PROGRESS_FAILED = "FAILED";

    public static final java.lang.String STATUS_NONE = "NONE";

    public static final java.lang.String STATUS_ACTIVE = "ACTIVE";

    public static final java.lang.String STATUS_STANDBY = "STANDBY";

    public static final java.lang.String STATUS_SWITCHING_TO_ACTIVE = "SWITCHING_TO_ACTIVE";

    public static final java.lang.String STATUS_SWITCHING_TO_STANDBY = "SWITCHING_TO_STANDBY";

    public static final java.lang.String STATUS_DECOMMISSIONED = "DECOMMISSIONED";

    private java.lang.String consolidatedProgress;

    private java.lang.Long endTime;

    private java.util.List<java.lang.String> errors;

    private java.util.List<com.vmware.nsx_global_policy.model.GmNodeStatus> nodeStatuses;

    private java.lang.Long siteManagerRef;

    private java.lang.Long startTime;

    private java.lang.String status;

    private java.util.List<java.lang.String> warnings;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public GmOperationalState() {
    }

    protected GmOperationalState(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_COMPLETED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_FAILED}</li>
     * </ul> Consolidated status of the current operation
     *
     * @return The current value of the property.
     */
    public java.lang.String getConsolidatedProgress() {
        return this.consolidatedProgress;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_COMPLETED}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_FAILED}</li>
     * </ul> Consolidated status of the current operation
     *
     * @param consolidatedProgress New value for the property.
     */
    public void setConsolidatedProgress(java.lang.String consolidatedProgress) {
        this.consolidatedProgress = consolidatedProgress;
    }

    /**
     * End time of the switchover operation format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getEndTime() {
        return this.endTime;
    }

    /**
     * End time of the switchover operation format: int64
     *
     * @param endTime New value for the property.
     */
    public void setEndTime(java.lang.Long endTime) {
        this.endTime = endTime;
    }

    /**
     * Errors if any
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getErrors() {
        return this.errors;
    }

    /**
     * Errors if any
     *
     * @param errors New value for the property.
     */
    public void setErrors(java.util.List<java.lang.String> errors) {
        this.errors = errors;
    }

    /**
     * Switchover status from each NSX Global Manager appliance node
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.GmNodeStatus> getNodeStatuses() {
        return this.nodeStatuses;
    }

    /**
     * Switchover status from each NSX Global Manager appliance node
     *
     * @param nodeStatuses New value for the property.
     */
    public void setNodeStatuses(java.util.List<com.vmware.nsx_global_policy.model.GmNodeStatus> nodeStatuses) {
        this.nodeStatuses = nodeStatuses;
    }

    /**
     * Timestamp reference for the change provided by SiteManager format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getSiteManagerRef() {
        return this.siteManagerRef;
    }

    /**
     * Timestamp reference for the change provided by SiteManager format: int64
     *
     * @param siteManagerRef New value for the property.
     */
    public void setSiteManagerRef(java.lang.Long siteManagerRef) {
        this.siteManagerRef = siteManagerRef;
    }

    /**
     * Start time of the switchover operation format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getStartTime() {
        return this.startTime;
    }

    /**
     * Start time of the switchover operation format: int64
     *
     * @param startTime New value for the property.
     */
    public void setStartTime(java.lang.Long startTime) {
        this.startTime = startTime;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_NONE}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_ACTIVE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_STANDBY}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_SWITCHING_TO_ACTIVE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_SWITCHING_TO_STANDBY}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_DECOMMISSIONED}</li>
     * </ul> The current switchover operation requested.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatus() {
        return this.status;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_NONE}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_ACTIVE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_STANDBY}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_SWITCHING_TO_ACTIVE}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_SWITCHING_TO_STANDBY}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_DECOMMISSIONED}</li>
     * </ul> The current switchover operation requested.
     *
     * @param status New value for the property.
     */
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * Errors if any
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getWarnings() {
        return this.warnings;
    }

    /**
     * Errors if any
     *
     * @param warnings New value for the property.
     */
    public void setWarnings(java.util.List<java.lang.String> warnings) {
        this.warnings = warnings;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.gmOperationalState;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("consolidated_progress",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.consolidatedProgress, this._getType().getField("consolidated_progress")));
        structValue.setField("end_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.endTime, this._getType().getField("end_time")));
        structValue.setField("errors",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errors, this._getType().getField("errors")));
        structValue.setField("node_statuses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeStatuses, this._getType().getField("node_statuses")));
        structValue.setField("site_manager_ref",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.siteManagerRef, this._getType().getField("site_manager_ref")));
        structValue.setField("start_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.startTime, this._getType().getField("start_time")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
        structValue.setField("warnings",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.warnings, this._getType().getField("warnings")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.gmOperationalState;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.gmOperationalState.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static GmOperationalState _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new GmOperationalState(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static GmOperationalState _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new GmOperationalState(structValue);
    }

    /**
     * Builder class for {@link GmOperationalState}.
     */
    public static final class Builder {
        private java.lang.String consolidatedProgress;
        private java.lang.Long endTime;
        private java.util.List<java.lang.String> errors;
        private java.util.List<com.vmware.nsx_global_policy.model.GmNodeStatus> nodeStatuses;
        private java.lang.Long siteManagerRef;
        private java.lang.Long startTime;
        private java.lang.String status;
        private java.util.List<java.lang.String> warnings;

        /**
         * Constructor with parameters for the required properties of
         * {@link GmOperationalState}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_IN_PROGRESS}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_COMPLETED}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.GmOperationalState#CONSOLIDATED_PROGRESS_FAILED}</li>
         * </ul> Consolidated status of the current operation
         *
         * @param consolidatedProgress New value for the property.
         */
        public Builder setConsolidatedProgress(java.lang.String consolidatedProgress) {
            this.consolidatedProgress = consolidatedProgress;
            return this;
        }

        /**
         * End time of the switchover operation format: int64
         *
         * @param endTime New value for the property.
         */
        public Builder setEndTime(java.lang.Long endTime) {
            this.endTime = endTime;
            return this;
        }

        /**
         * Errors if any
         *
         * @param errors New value for the property.
         */
        public Builder setErrors(java.util.List<java.lang.String> errors) {
            this.errors = errors;
            return this;
        }

        /**
         * Switchover status from each NSX Global Manager appliance node
         *
         * @param nodeStatuses New value for the property.
         */
        public Builder setNodeStatuses(java.util.List<com.vmware.nsx_global_policy.model.GmNodeStatus> nodeStatuses) {
            this.nodeStatuses = nodeStatuses;
            return this;
        }

        /**
         * Timestamp reference for the change provided by SiteManager format: int64
         *
         * @param siteManagerRef New value for the property.
         */
        public Builder setSiteManagerRef(java.lang.Long siteManagerRef) {
            this.siteManagerRef = siteManagerRef;
            return this;
        }

        /**
         * Start time of the switchover operation format: int64
         *
         * @param startTime New value for the property.
         */
        public Builder setStartTime(java.lang.Long startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_NONE}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_ACTIVE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_STANDBY}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_SWITCHING_TO_ACTIVE}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_SWITCHING_TO_STANDBY}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.GmOperationalState#STATUS_DECOMMISSIONED}</li>
         * </ul> The current switchover operation requested.
         *
         * @param status New value for the property.
         */
        public Builder setStatus(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Errors if any
         *
         * @param warnings New value for the property.
         */
        public Builder setWarnings(java.util.List<java.lang.String> warnings) {
            this.warnings = warnings;
            return this;
        }

        public GmOperationalState build() {
            GmOperationalState result = new GmOperationalState();
            result.setConsolidatedProgress(this.consolidatedProgress);
            result.setEndTime(this.endTime);
            result.setErrors(this.errors);
            result.setNodeStatuses(this.nodeStatuses);
            result.setSiteManagerRef(this.siteManagerRef);
            result.setStartTime(this.startTime);
            result.setStatus(this.status);
            result.setWarnings(this.warnings);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("consolidated_progress", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("consolidated_progress",
                                                                                "consolidatedProgress",
                                                                                "getConsolidatedProgress",
                                                                                "setConsolidatedProgress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("end_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("end_time",
                                                                                "endTime",
                                                                                "getEndTime",
                                                                                "setEndTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("errors", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("errors",
                                                                                "errors",
                                                                                "getErrors",
                                                                                "setErrors");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_statuses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.gmNodeStatus; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_statuses",
                                                                                "nodeStatuses",
                                                                                "getNodeStatuses",
                                                                                "setNodeStatuses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_manager_ref", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_manager_ref",
                                                                                "siteManagerRef",
                                                                                "getSiteManagerRef",
                                                                                "setSiteManagerRef");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("start_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("start_time",
                                                                                "startTime",
                                                                                "getStartTime",
                                                                                "setStartTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("warnings", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("warnings",
                                                                                "warnings",
                                                                                "getWarnings",
                                                                                "setWarnings");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.gm_operational_state",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.GmOperationalState.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

