/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Key Store information about the url alias or datasource.
 */
public final class KeyStoreInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String keystore;

    private java.lang.String keystoreAlias;

    private java.lang.String keystorePhrase;

    private java.lang.String truststore;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public KeyStoreInfo() {
    }

    protected KeyStoreInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * A location of the keystor file which stores private key and identity
     * certificates that will be presented to both parties (server or client) for
     * verification.
     *
     * @return The current value of the property.
     */
    public java.lang.String getKeystore() {
        return this.keystore;
    }

    /**
     * A location of the keystor file which stores private key and identity
     * certificates that will be presented to both parties (server or client) for
     * verification.
     *
     * @param keystore New value for the property.
     */
    public void setKeystore(java.lang.String keystore) {
        this.keystore = keystore;
    }

    /**
     * Its an alias specified when an entity is added to the keystore.
     *
     * @return The current value of the property.
     */
    public java.lang.String getKeystoreAlias() {
        return this.keystoreAlias;
    }

    /**
     * Its an alias specified when an entity is added to the keystore.
     *
     * @param keystoreAlias New value for the property.
     */
    public void setKeystoreAlias(java.lang.String keystoreAlias) {
        this.keystoreAlias = keystoreAlias;
    }

    /**
     * A location of the key store pass phrase file.
     *
     * @return The current value of the property.
     */
    public java.lang.String getKeystorePhrase() {
        return this.keystorePhrase;
    }

    /**
     * A location of the key store pass phrase file.
     *
     * @param keystorePhrase New value for the property.
     */
    public void setKeystorePhrase(java.lang.String keystorePhrase) {
        this.keystorePhrase = keystorePhrase;
    }

    /**
     * A location of the trust store file which stores the certificate from CA that
     * verify the certificate presented by the server in SSL connection.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTruststore() {
        return this.truststore;
    }

    /**
     * A location of the trust store file which stores the certificate from CA that
     * verify the certificate presented by the server in SSL connection.
     *
     * @param truststore New value for the property.
     */
    public void setTruststore(java.lang.String truststore) {
        this.truststore = truststore;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.keyStoreInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("keystore",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keystore, this._getType().getField("keystore")));
        structValue.setField("keystore_alias",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keystoreAlias, this._getType().getField("keystore_alias")));
        structValue.setField("keystore_phrase",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.keystorePhrase, this._getType().getField("keystore_phrase")));
        structValue.setField("truststore",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.truststore, this._getType().getField("truststore")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.keyStoreInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.keyStoreInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static KeyStoreInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new KeyStoreInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static KeyStoreInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new KeyStoreInfo(structValue);
    }

    /**
     * Builder class for {@link KeyStoreInfo}.
     */
    public static final class Builder {
        private java.lang.String keystore;
        private java.lang.String keystoreAlias;
        private java.lang.String keystorePhrase;
        private java.lang.String truststore;

        /**
         * Constructor with parameters for the required properties of
         * {@link KeyStoreInfo}.
         */
        public Builder() {
        }

        /**
         * A location of the keystor file which stores private key and identity
         * certificates that will be presented to both parties (server or client) for
         * verification.
         *
         * @param keystore New value for the property.
         */
        public Builder setKeystore(java.lang.String keystore) {
            this.keystore = keystore;
            return this;
        }

        /**
         * Its an alias specified when an entity is added to the keystore.
         *
         * @param keystoreAlias New value for the property.
         */
        public Builder setKeystoreAlias(java.lang.String keystoreAlias) {
            this.keystoreAlias = keystoreAlias;
            return this;
        }

        /**
         * A location of the key store pass phrase file.
         *
         * @param keystorePhrase New value for the property.
         */
        public Builder setKeystorePhrase(java.lang.String keystorePhrase) {
            this.keystorePhrase = keystorePhrase;
            return this;
        }

        /**
         * A location of the trust store file which stores the certificate from CA that
         * verify the certificate presented by the server in SSL connection.
         *
         * @param truststore New value for the property.
         */
        public Builder setTruststore(java.lang.String truststore) {
            this.truststore = truststore;
            return this;
        }

        public KeyStoreInfo build() {
            KeyStoreInfo result = new KeyStoreInfo();
            result.setKeystore(this.keystore);
            result.setKeystoreAlias(this.keystoreAlias);
            result.setKeystorePhrase(this.keystorePhrase);
            result.setTruststore(this.truststore);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("keystore", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("keystore",
                                                                                "keystore",
                                                                                "getKeystore",
                                                                                "setKeystore");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("keystore_alias", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("keystore_alias",
                                                                                "keystoreAlias",
                                                                                "getKeystoreAlias",
                                                                                "setKeystoreAlias");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("keystore_phrase", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("keystore_phrase",
                                                                                "keystorePhrase",
                                                                                "getKeystorePhrase",
                                                                                "setKeystorePhrase");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("truststore", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("truststore",
                                                                                "truststore",
                                                                                "getTruststore",
                                                                                "setTruststore");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.key_store_info",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.KeyStoreInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

