/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * This action is used to redirect HTTP request messages to a new URL. The
 * reply_status value specified in this action is used as the status code of HTTP
 * response message which is sent back to client (Normally a browser). The HTTP
 * status code for redirection is 3xx, for example, 301, 302, 303, 307, etc. The
 * redirect_url is the new URL that the HTTP request message is redirected to.
 * Normally browser will send another HTTP request to the new URL after receiving a
 * redirection response message. Captured variables and built-in variables can be
 * used in redirect_url field. For example, to redirect all HTTP requests to HTTPS
 * requests for a virtual server. We create an LBRule without any conditions, add
 * an LBHttpRedirectAction to the rule. Set the redirect_url field of the
 * LBHttpRedirectAction to: https://$_host$_request_uri And set redirect_status to
 * \"302\", which means found. This rule will redirect all HTTP requests to HTTPS
 * server port on the same host.
 */
public final class LBHttpRedirectAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBHttpRedirectAction";

    private java.lang.String redirectStatus;

    private java.lang.String redirectUrl;

    private final java.lang.String type = "LBHttpRedirectAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBHttpRedirectAction() {
    }

    protected LBHttpRedirectAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * HTTP response status code.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRedirectStatus() {
        return this.redirectStatus;
    }

    /**
     * HTTP response status code.
     *
     * @param redirectStatus New value for the property.
     */
    public void setRedirectStatus(java.lang.String redirectStatus) {
        this.redirectStatus = redirectStatus;
    }

    /**
     * The URL that the HTTP request is redirected to.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRedirectUrl() {
        return this.redirectUrl;
    }

    /**
     * The URL that the HTTP request is redirected to.
     *
     * @param redirectUrl New value for the property.
     */
    public void setRedirectUrl(java.lang.String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBSELECTPOOLACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREJECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREDIRECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBJWTAUTHACTION}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBCONNECTIONDROPACTION}</li>
     * </ul> The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LBHttpRedirectAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRedirectAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("redirect_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.redirectStatus, this._getType().getField("redirect_status")));
        structValue.setField("redirect_url",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.redirectUrl, this._getType().getField("redirect_url")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRedirectAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRedirectAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBHttpRedirectAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBHttpRedirectAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBHttpRedirectAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBHttpRedirectAction(structValue);
    }

    /**
     * Builder class for {@link LBHttpRedirectAction}.
     */
    public static final class Builder {
        private java.lang.String redirectStatus;
        private java.lang.String redirectUrl;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBHttpRedirectAction}.
         */
        public Builder() {
        }

        /**
         * HTTP response status code.
         *
         * @param redirectStatus New value for the property.
         */
        public Builder setRedirectStatus(java.lang.String redirectStatus) {
            this.redirectStatus = redirectStatus;
            return this;
        }

        /**
         * The URL that the HTTP request is redirected to.
         *
         * @param redirectUrl New value for the property.
         */
        public Builder setRedirectUrl(java.lang.String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public LBHttpRedirectAction build() {
            LBHttpRedirectAction result = new LBHttpRedirectAction();
            result.setRedirectStatus(this.redirectStatus);
            result.setRedirectUrl(this.redirectUrl);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("redirect_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("redirect_status",
                                                                                "redirectStatus",
                                                                                "getRedirectStatus",
                                                                                "setRedirectStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("redirect_url", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("redirect_url",
                                                                                "redirectUrl",
                                                                                "getRedirectUrl",
                                                                                "setRedirectUrl");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.LB_http_redirect_action",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.LBHttpRedirectAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LBHttpRedirectAction");
    }
}

