/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * This action is used to reject HTTP request messages. The specified reply_status
 * value is used as the status code for the corresponding HTTP response message
 * which is sent back to client (Normally a browser) indicating the reason it was
 * rejected. Reference official HTTP status code list for your specific HTTP
 * version to set the reply_status properly. LBHttpRejectAction does not support
 * variables.
 */
public final class LBHttpRejectAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBHttpRejectAction";

    private java.lang.String replyMessage;

    private java.lang.String replyStatus;

    private final java.lang.String type = "LBHttpRejectAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBHttpRejectAction() {
    }

    protected LBHttpRejectAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Response message.
     *
     * @return The current value of the property.
     */
    public java.lang.String getReplyMessage() {
        return this.replyMessage;
    }

    /**
     * Response message.
     *
     * @param replyMessage New value for the property.
     */
    public void setReplyMessage(java.lang.String replyMessage) {
        this.replyMessage = replyMessage;
    }

    /**
     * HTTP response status code.
     *
     * @return The current value of the property.
     */
    public java.lang.String getReplyStatus() {
        return this.replyStatus;
    }

    /**
     * HTTP response status code.
     *
     * @param replyStatus New value for the property.
     */
    public void setReplyStatus(java.lang.String replyStatus) {
        this.replyStatus = replyStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBSELECTPOOLACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREJECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREDIRECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBJWTAUTHACTION}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBCONNECTIONDROPACTION}</li>
     * </ul> The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LBHttpRejectAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRejectAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("reply_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.replyMessage, this._getType().getField("reply_message")));
        structValue.setField("reply_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.replyStatus, this._getType().getField("reply_status")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRejectAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRejectAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBHttpRejectAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBHttpRejectAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBHttpRejectAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBHttpRejectAction(structValue);
    }

    /**
     * Builder class for {@link LBHttpRejectAction}.
     */
    public static final class Builder {
        private java.lang.String replyMessage;
        private java.lang.String replyStatus;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBHttpRejectAction}.
         */
        public Builder() {
        }

        /**
         * Response message.
         *
         * @param replyMessage New value for the property.
         */
        public Builder setReplyMessage(java.lang.String replyMessage) {
            this.replyMessage = replyMessage;
            return this;
        }

        /**
         * HTTP response status code.
         *
         * @param replyStatus New value for the property.
         */
        public Builder setReplyStatus(java.lang.String replyStatus) {
            this.replyStatus = replyStatus;
            return this;
        }

        public LBHttpRejectAction build() {
            LBHttpRejectAction result = new LBHttpRejectAction();
            result.setReplyMessage(this.replyMessage);
            result.setReplyStatus(this.replyStatus);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("reply_message", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reply_message",
                                                                                "replyMessage",
                                                                                "getReplyMessage",
                                                                                "setReplyMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reply_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reply_status",
                                                                                "replyStatus",
                                                                                "getReplyStatus",
                                                                                "setReplyStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.LB_http_reject_action",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.LBHttpRejectAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LBHttpRejectAction");
    }
}

