/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * This action is used to rewrite header fields of matched HTTP request messages to
 * specified new values. One action can be used to rewrite one header field. To
 * rewrite multiple header fields, multiple actions must be defined. Captured
 * variables and built-in variables can be used in the header_value field,
 * header_name field does not support variables.
 */
public final class LBHttpRequestHeaderRewriteAction implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LBHttpRequestHeaderRewriteAction";

    private java.lang.String headerName;

    private java.lang.String headerValue;

    private final java.lang.String type = "LBHttpRequestHeaderRewriteAction";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBHttpRequestHeaderRewriteAction() {
    }

    protected LBHttpRequestHeaderRewriteAction(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Name of HTTP request header.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHeaderName() {
        return this.headerName;
    }

    /**
     * Name of HTTP request header.
     *
     * @param headerName New value for the property.
     */
    public void setHeaderName(java.lang.String headerName) {
        this.headerName = headerName;
    }

    /**
     * Value of HTTP request header.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHeaderValue() {
        return this.headerValue;
    }

    /**
     * Value of HTTP request header.
     *
     * @param headerValue New value for the property.
     */
    public void setHeaderValue(java.lang.String headerValue) {
        this.headerValue = headerValue;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBSELECTPOOLACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTURIREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREJECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREDIRECTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERREWRITEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPREQUESTHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBHTTPRESPONSEHEADERDELETEACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEASSIGNMENTACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCEONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBVARIABLEPERSISTENCELEARNACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBJWTAUTHACTION}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBSSLMODESELECTIONACTION}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction#TYPE_LBCONNECTIONDROPACTION}</li>
     * </ul> The property identifies the load balancer rule action type.
     * The value of this property is automatically populated to {@code "LBHttpRequestHeaderRewriteAction"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestHeaderRewriteAction;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("header_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.headerName, this._getType().getField("header_name")));
        structValue.setField("header_value",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.headerValue, this._getType().getField("header_value")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestHeaderRewriteAction;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBHttpRequestHeaderRewriteAction.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBHttpRequestHeaderRewriteAction _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBHttpRequestHeaderRewriteAction(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBHttpRequestHeaderRewriteAction _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBHttpRequestHeaderRewriteAction(structValue);
    }

    /**
     * Builder class for {@link LBHttpRequestHeaderRewriteAction}.
     */
    public static final class Builder {
        private java.lang.String headerName;
        private java.lang.String headerValue;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBHttpRequestHeaderRewriteAction}.
         */
        public Builder() {
        }

        /**
         * Name of HTTP request header.
         *
         * @param headerName New value for the property.
         */
        public Builder setHeaderName(java.lang.String headerName) {
            this.headerName = headerName;
            return this;
        }

        /**
         * Value of HTTP request header.
         *
         * @param headerValue New value for the property.
         */
        public Builder setHeaderValue(java.lang.String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public LBHttpRequestHeaderRewriteAction build() {
            LBHttpRequestHeaderRewriteAction result = new LBHttpRequestHeaderRewriteAction();
            result.setHeaderName(this.headerName);
            result.setHeaderValue(this.headerValue);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("header_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("header_name",
                                                                                "headerName",
                                                                                "getHeaderName",
                                                                                "setHeaderName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("header_value", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("header_value",
                                                                                "headerValue",
                                                                                "getHeaderValue",
                                                                                "setHeaderValue");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.LB_http_request_header_rewrite_action",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.LBHttpRequestHeaderRewriteAction.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LBHttpRequestHeaderRewriteAction");
    }
}

