/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Binding of a LBPool and Group to a LBVirtualServer used to route application
 * traffic passing through load balancers. LBRule uses match conditions to match
 * application traffic passing through a LBVirtualServer using HTTP or HTTPS. Can
 * bind multiple LBVirtualServers to a Group. Each LBRule consists of two optional
 * match conditions, each match contidion defines a criterion for application
 * traffic. If no match conditions are specified, then the LBRule will always match
 * and it is used typically to define default rules. If more than one match
 * condition is specified, then matching strategy determines if all conditions
 * should match or any one condition should match for the LBRule to be considered a
 * match. A match indicates that the LBVirtualServer should route the request to
 * the Group (parent of LBRule). LBRule is deprecated as NSX-T Load Balancer is
 * deprecated.
 */
public final class LBRule implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String MATCH_STRATEGY_ALL = "ALL";

    public static final java.lang.String MATCH_STRATEGY_ANY = "ANY";

    public static final java.lang.String PHASE_HTTP_REQUEST_REWRITE = "HTTP_REQUEST_REWRITE";

    public static final java.lang.String PHASE_HTTP_FORWARDING = "HTTP_FORWARDING";

    public static final java.lang.String PHASE_HTTP_RESPONSE_REWRITE = "HTTP_RESPONSE_REWRITE";

    public static final java.lang.String PHASE_HTTP_ACCESS = "HTTP_ACCESS";

    public static final java.lang.String PHASE_TRANSPORT = "TRANSPORT";

    private java.util.List<com.vmware.vapi.bindings.Structure> actions;

    private java.lang.String displayName;

    private java.util.List<com.vmware.vapi.bindings.Structure> matchConditions;

    private java.lang.String matchStrategy;

    private java.lang.String phase;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBRule() {
    }

    protected LBRule(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * A list of actions to be executed at specified phase when load balancer rule
     * matches. The actions are used to manipulate application traffic, such as rewrite
     * URI of HTTP messages, redirect HTTP messages, etc.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction}. When methods return a value of
     * this class as a return value, the property will contain all the properties
     * defined in {@link com.vmware.nsx_global_policy.model.LBRuleAction}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getActions() {
        return this.actions;
    }

    /**
     * A list of actions to be executed at specified phase when load balancer rule
     * matches. The actions are used to manipulate application traffic, such as rewrite
     * URI of HTTP messages, redirect HTTP messages, etc.
     *
     * @param actions New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LBRuleAction}. When methods return a value of
     * this class as a return value, the property will contain all the properties
     * defined in {@link com.vmware.nsx_global_policy.model.LBRuleAction}.
     */
    public void setActions(java.util.List<com.vmware.vapi.bindings.Structure> actions) {
        this.actions = actions;
    }

    /**
     * A display name useful for identifying an LBRule.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * A display name useful for identifying an LBRule.
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * A list of match conditions used to match application traffic. Multiple match
     * conditions can be specified in one load balancer rule, each match condition
     * defines a criterion to match application traffic. If no match conditions are
     * specified, then the load balancer rule will always match and it is used
     * typically to define default rules. If more than one match condition is
     * specified, then match strategy determines if all conditions should match or any
     * one condition should match for the load balancer rule to considered a match.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LBRuleCondition}. When methods return a value
     * of this class as a return value, the property will contain all the properties
     * defined in {@link com.vmware.nsx_global_policy.model.LBRuleCondition}.
     */
    public java.util.List<com.vmware.vapi.bindings.Structure> getMatchConditions() {
        return this.matchConditions;
    }

    /**
     * A list of match conditions used to match application traffic. Multiple match
     * conditions can be specified in one load balancer rule, each match condition
     * defines a criterion to match application traffic. If no match conditions are
     * specified, then the load balancer rule will always match and it is used
     * typically to define default rules. If more than one match condition is
     * specified, then match strategy determines if all conditions should match or any
     * one condition should match for the load balancer rule to considered a match.
     *
     * @param matchConditions New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LBRuleCondition}. When methods return a value
     * of this class as a return value, the property will contain all the properties
     * defined in {@link com.vmware.nsx_global_policy.model.LBRuleCondition}.
     */
    public void setMatchConditions(java.util.List<com.vmware.vapi.bindings.Structure> matchConditions) {
        this.matchConditions = matchConditions;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRule#MATCH_STRATEGY_ALL}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRule#MATCH_STRATEGY_ANY}</li> </ul> If more
     * than one match condition is specified, then matching strategy determines if all
     * conditions should match or any one condition should match for the LB Rule to be
     * considered a match. - ALL indicates that both host_match and path_match must
     * match for this LBRule to be considered a match. - ANY indicates that either
     * host_match or patch match may match for this LBRule to be considered a match.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMatchStrategy() {
        return this.matchStrategy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRule#MATCH_STRATEGY_ALL}</li> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRule#MATCH_STRATEGY_ANY}</li> </ul> If more
     * than one match condition is specified, then matching strategy determines if all
     * conditions should match or any one condition should match for the LB Rule to be
     * considered a match. - ALL indicates that both host_match and path_match must
     * match for this LBRule to be considered a match. - ANY indicates that either
     * host_match or patch match may match for this LBRule to be considered a match.
     *
     * @param matchStrategy New value for the property.
     */
    public void setMatchStrategy(java.lang.String matchStrategy) {
        this.matchStrategy = matchStrategy;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_REQUEST_REWRITE}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_FORWARDING}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_RESPONSE_REWRITE}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_ACCESS}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_TRANSPORT}</li> </ul>
     * Each load balancer rule is used at a specific phase of load balancer processing.
     * Currently five phases are supported, HTTP_REQUEST_REWRITE, HTTP_FORWARDING,
     * HTTP_RESPONSE_REWRITE, HTTP_ACCESS and TRANSPORT. When an HTTP request message
     * is received by load balancer, all HTTP_REQUEST_REWRITE rules, if present are
     * executed in the order they are applied to virtual server. And then if
     * HTTP_FORWARDING rules present, only first matching rule's action is executed,
     * remaining rules are not checked. HTTP_FORWARDING rules can have only one action.
     * If the request is forwarded to a backend server and the response goes back to
     * load balancer, all HTTP_RESPONSE_REWRITE rules, if present, are executed in the
     * order they are applied to the virtual server. In HTTP_ACCESS phase, user can
     * define action to control access using JWT authentication. In TRANSPORT phase,
     * user can define the condition to match SNI in TLS client hello and define the
     * action to do SSL end-to-end, SSL offloading or SSL passthrough using a specific
     * load balancer server pool.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPhase() {
        return this.phase;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_REQUEST_REWRITE}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_FORWARDING}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_RESPONSE_REWRITE}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_ACCESS}</li> <li>
     * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_TRANSPORT}</li> </ul>
     * Each load balancer rule is used at a specific phase of load balancer processing.
     * Currently five phases are supported, HTTP_REQUEST_REWRITE, HTTP_FORWARDING,
     * HTTP_RESPONSE_REWRITE, HTTP_ACCESS and TRANSPORT. When an HTTP request message
     * is received by load balancer, all HTTP_REQUEST_REWRITE rules, if present are
     * executed in the order they are applied to virtual server. And then if
     * HTTP_FORWARDING rules present, only first matching rule's action is executed,
     * remaining rules are not checked. HTTP_FORWARDING rules can have only one action.
     * If the request is forwarded to a backend server and the response goes back to
     * load balancer, all HTTP_RESPONSE_REWRITE rules, if present, are executed in the
     * order they are applied to the virtual server. In HTTP_ACCESS phase, user can
     * define action to control access using JWT authentication. In TRANSPORT phase,
     * user can define the condition to match SNI in TLS client hello and define the
     * action to do SSL end-to-end, SSL offloading or SSL passthrough using a specific
     * load balancer server pool.
     *
     * @param phase New value for the property.
     */
    public void setPhase(java.lang.String phase) {
        this.phase = phase;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBRule;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("actions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.actions, this._getType().getField("actions")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("match_conditions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchConditions, this._getType().getField("match_conditions")));
        structValue.setField("match_strategy",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.matchStrategy, this._getType().getField("match_strategy")));
        structValue.setField("phase",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.phase, this._getType().getField("phase")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBRule;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBRule.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBRule _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBRule(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBRule _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBRule(structValue);
    }

    /**
     * Builder class for {@link LBRule}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.vapi.bindings.Structure> actions;
        private java.lang.String displayName;
        private java.util.List<com.vmware.vapi.bindings.Structure> matchConditions;
        private java.lang.String matchStrategy;
        private java.lang.String phase;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBRule}.
         */
        public Builder() {
        }

        /**
         * A list of actions to be executed at specified phase when load balancer rule
         * matches. The actions are used to manipulate application traffic, such as rewrite
         * URI of HTTP messages, redirect HTTP messages, etc.
         *
         * @param actions New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_global_policy.model.LBRuleAction}. When methods return a value of
         * this class as a return value, the property will contain all the properties
         * defined in {@link com.vmware.nsx_global_policy.model.LBRuleAction}.
         */
        public Builder setActions(java.util.List<com.vmware.vapi.bindings.Structure> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * A display name useful for identifying an LBRule.
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * A list of match conditions used to match application traffic. Multiple match
         * conditions can be specified in one load balancer rule, each match condition
         * defines a criterion to match application traffic. If no match conditions are
         * specified, then the load balancer rule will always match and it is used
         * typically to define default rules. If more than one match condition is
         * specified, then match strategy determines if all conditions should match or any
         * one condition should match for the load balancer rule to considered a match.
         *
         * @param matchConditions New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx_global_policy.model.LBRuleCondition}. When methods return a value
         * of this class as a return value, the property will contain all the properties
         * defined in {@link com.vmware.nsx_global_policy.model.LBRuleCondition}.
         */
        public Builder setMatchConditions(java.util.List<com.vmware.vapi.bindings.Structure> matchConditions) {
            this.matchConditions = matchConditions;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.LBRule#MATCH_STRATEGY_ALL}</li> <li> {@link
         * com.vmware.nsx_global_policy.model.LBRule#MATCH_STRATEGY_ANY}</li> </ul> If more
         * than one match condition is specified, then matching strategy determines if all
         * conditions should match or any one condition should match for the LB Rule to be
         * considered a match. - ALL indicates that both host_match and path_match must
         * match for this LBRule to be considered a match. - ANY indicates that either
         * host_match or patch match may match for this LBRule to be considered a match.
         *
         * @param matchStrategy New value for the property.
         */
        public Builder setMatchStrategy(java.lang.String matchStrategy) {
            this.matchStrategy = matchStrategy;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_REQUEST_REWRITE}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_FORWARDING}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_RESPONSE_REWRITE}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_HTTP_ACCESS}</li> <li>
         * {@link com.vmware.nsx_global_policy.model.LBRule#PHASE_TRANSPORT}</li> </ul>
         * Each load balancer rule is used at a specific phase of load balancer processing.
         * Currently five phases are supported, HTTP_REQUEST_REWRITE, HTTP_FORWARDING,
         * HTTP_RESPONSE_REWRITE, HTTP_ACCESS and TRANSPORT. When an HTTP request message
         * is received by load balancer, all HTTP_REQUEST_REWRITE rules, if present are
         * executed in the order they are applied to virtual server. And then if
         * HTTP_FORWARDING rules present, only first matching rule's action is executed,
         * remaining rules are not checked. HTTP_FORWARDING rules can have only one action.
         * If the request is forwarded to a backend server and the response goes back to
         * load balancer, all HTTP_RESPONSE_REWRITE rules, if present, are executed in the
         * order they are applied to the virtual server. In HTTP_ACCESS phase, user can
         * define action to control access using JWT authentication. In TRANSPORT phase,
         * user can define the condition to match SNI in TLS client hello and define the
         * action to do SSL end-to-end, SSL offloading or SSL passthrough using a specific
         * load balancer server pool.
         *
         * @param phase New value for the property.
         */
        public Builder setPhase(java.lang.String phase) {
            this.phase = phase;
            return this;
        }

        public LBRule build() {
            LBRule result = new LBRule();
            result.setActions(this.actions);
            result.setDisplayName(this.displayName);
            result.setMatchConditions(this.matchConditions);
            result.setMatchStrategy(this.matchStrategy);
            result.setPhase(this.phase);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("actions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.LBRuleAction; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("actions",
                                                                                "actions",
                                                                                "getActions",
                                                                                "setActions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_conditions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.LBRuleCondition; } }))))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_conditions",
                                                                                "matchConditions",
                                                                                "getMatchConditions",
                                                                                "setMatchConditions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("match_strategy", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("match_strategy",
                                                                                "matchStrategy",
                                                                                "getMatchStrategy",
                                                                                "setMatchStrategy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("phase", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("phase",
                                                                                "phase",
                                                                                "getPhase",
                                                                                "setPhase");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.LB_rule",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.LBRule.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

